/**
 * Handles mouse events for ALL GWindow objects
 *  
 * @param appc the PApplet object embeded into the frame
 * @param data the data for the GWindow being used
 * @param event the mouse event
 */
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
void windowMouse(GWinApplet appc, GWinData data, MouseEvent event) {
  MyWinData data2 = (MyWinData)data;
  switch(event.getAction()) {
  case MouseEvent.PRESS:
    data2.sx = data2.ex = appc.mouseX;
    data2.sy = data2.ey = appc.mouseY;
    data2.done = false;
    break;
  case MouseEvent.RELEASE:
    data2.ex = appc.mouseX;
    data2.ey = appc.mouseY;
    data2.done = true;
    break;
  case MouseEvent.DRAG:
    data2.ex = appc.mouseX;
    data2.ey = appc.mouseY;
    break;
  }
}
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
/**
 * Click the button to create the windows.
 * @param button
 */
public void handleButtonEvents(GButton button, GEvent event) { 
  // Folder selection
  if (button == btnInput) {
    handleFileDialog(button);
  } else if (button == btnRst) {
    sdr.setValue(0);
    sdr1.setValue(0);
    sdr.setValue(0);
    sdr2.setValue(200);
    sdr3.setValue(200);
    sdr5.setValue(200);
    graph(true);
  } else if (button == btntemp) {
    //btntemp.setSelected(tempGraph);
    tempGraph = !tempGraph;
    graph(false);
  } else if (button == btnPNG) {
    saveFrame("TH_Screen-####.png");
  }
}

/**
 * Simple class that extends GWinData and holds the data 
 * that is specific to a particular window.
 * 
 * @author Peter Lager
 */
class MyWinData extends GWinData {
  int sx, sy, ex, ey;
  boolean done;
}

void windowDraw(GWinApplet appc, GWinData data) {
  MyWinData data2 = (MyWinData)data;
  if (!(data2.sx == data2.ex && data2.ey == data2.ey)) {

    appc.stroke(0);
    appc.strokeWeight(2);
    appc.noFill();
    if (data2.done) {
      appc.fill(128);
    }
    appc.rectMode(CORNERS);
    appc.rect(data2.sx, data2.sy, data2.ex, data2.ey);
  }
} 
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
public void createFileSystemGUI(int x, int y, int w, int h, int border) {

  btnInput = new GButton(this, x, y, w, h, "Input");
  lblFile = new GLabel(this, x, y-28, w+300, 28);
  lblFile.setTextAlign(GAlign.LEFT, GAlign.MIDDLE);
  lblFile.setOpaque(true);
  lblFile.setLocalColorScheme(G4P.GREEN_SCHEME);
  btnRst = new GButton(this, x+75, y, w, h, "Reset");
  btntemp = new GButton(this, x+150, y, w, h, "Temp");
  lblFile.setText(fname);
  btnPNG = new GButton(this, x+225, y, w, h, "Exp PNG");
}


// G4P code for folder and file dialogs
public void handleFileDialog(GButton button) {

  // Folder selection
  if (button == btnInput) {
    // Use file filter if possible
    try {
      fname = G4P.selectInput("Input Dialog", "png,gif,jpg,jpeg", "Image files");

      fname = fname.replace("\\", "/");
      lblFile.setText(fname);
      newFileSettings();

      graph(true);
    } 
    catch (NullPointerException e) {
      fname=fname;
    }
  }
}

// G4P code for message dialogs
public void handleMessageDialog() {
  // Determine message type
  int mtype;
  switch(md_mtype) {
  default:
  case 0: 
    mtype = G4P.PLAIN; 
    break;
  case 1: 
    mtype = G4P.ERROR; 
    break;
  case 2: 
    mtype = G4P.INFO; 
    break;
  case 3: 
    mtype = G4P.WARNING; 
    break;
  case 4: 
    mtype = G4P.QUERY; 
    break;
  }
  String message = txfSMMessage.getText();
  String title = txfMdTitle.getText();
  G4P.showMessage(this, message, title, mtype);
}

public void handleSliderEvents(GValueControl slider, GEvent event) { 
  if (slider == sdr || slider == sdr1 || slider == sdr2 || slider == sdr3 || slider == sdr4 || slider == sdr5) {// The slider being configured?
    sliderZoom();
    sliderShift();
    graph(false);
  }
}
