import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import processing.serial.*; 
import java.util.*; 
import java.text.*; 
import de.bezier.guido.*; 
import g4p_controls.*; 
import java.awt.Rectangle; 
import java.util.ArrayList; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class Graph extends PApplet {

// The data path of the folder to look in (write your own)
java.io.File folder = new java.io.File(dataPath("E:/"));








GSlider sdr;
GSlider sdr1;
GSlider sdr2;
GSlider sdr3;
GSlider sdr4;
GSlider sdr5;
GButton btnStart;
GLabel lblInstr;
PGraphics pg;

Table table;
Serial myPort;        // The serial port
long minXval;
long maxXval;
long vminXval;
long vmaxXval;
int minYval=100000;
int maxYval;
int minY2val=100000;
int maxY2val;
int vminYval=100000;
int vmaxYval;
int vminY2val=100000;
int vmaxY2val;
int mx, my, mx1, my1;
int currWidth, currHeight;
long xSpan;
long xvSpan;
int ySpan;
int y2Span;
int yvSpan;
int y2vSpan;
int zoomX1;
String mm;
String Ch4 = " Ch4";
String tempT;
String Time;
String Date;
float F;

int zoomY1;
boolean mouseClick = false;
boolean mmCalc = false;
boolean tempTCalc = false;
boolean tempGraph = false;

// Controls used for file dialog GUI 
PImage img;

GButton btnRst, btnInput, btntemp, btnPNG;
GLabel lblFile;
GCheckbox cbxUseNative;

// Graphic frames used to group controls
ArrayList<Rectangle> rects ;
int md_mtype;
GTextArea txfSMMessage;
GTextField txfMdTitle;
String fname = "../Example Data/010515.csv";

// let's set a filter (which returns true if file's extension is .csv)
java.io.FilenameFilter jpgFilter = new java.io.FilenameFilter() {
  public boolean accept(File dir, String name) {
    return name.toLowerCase().endsWith(".csv");
  }
};

// list all the folders inside the main directory
String[] listFolders = folder.list(new java.io.FilenameFilter() {
  public boolean accept(File current, String name) {
    return new File(current, name).isFile();
  }
}
);

// list the files in the data folder, passing the filter as parameter
String[] filenames = folder.list(jpgFilter);
String[] foldernames = folder.list();

//// get and display the number of jpg files
//println(filenames.length + " csv files in specified directory");
//println(foldernames.length + " files in the specified directory");
// 
//// display the folder names
//for(int i=0; i < foldernames.length-1; i++) {
//  println(listFolders[i]);
//}
// 
//// display the filenames
//for (int i = 0; i < filenames.length; i++) {
//  println(filenames[i]);
//}

public void setup() {

  // fname = G4P.selectInput("Input CSV File", "csv", "Data files");

  size(displayWidth, displayHeight-70);
  if (frame != null) {
    frame.setResizable(true);
  }
   registerMethod("pre", this);
  //btnStart = new GButton(this, 4, 34, 120, 60, "Create 3 Windows");
  lblInstr = new GLabel(this, 132, 34, 120, 60, "Use the mouse to draw a rectangle in any of the 3 windows");
  lblInstr.setTextAlign(GAlign.CENTER, GAlign.MIDDLE);
  lblInstr.setVisible(false);

  img = loadImage("GCS Logo.png");
  sdr = new GSlider(this, width/2-100, height-40, 200, 20, 15); 
  sdr1 = new GSlider(this, 20, height/2+100, 200, 20, 15);
  sdr4 = new GSlider(this, width-37, height/2, 200, 20, 15);
  sdr2 = new GSlider(this, width/2-400, height-20, 800, 15, 10); 
  sdr3 = new GSlider(this, 05, height/2+200, 400, 15, 10); 
  sdr5 = new GSlider(this, width-20, height/2+100, 400, 20, 10); 
  setSliders();
  rects = new ArrayList<Rectangle> ();
  //    window = new GWindow(this, "Window "+1, 70+1*220, 160+1*50, 200, 200, false, JAVA2D);
  //    window.setBackground(255);
  //    window.addData(new MyWinData());
  //    window.addDrawHandler(this, "windowDraw");
  //    window.addMouseHandler(this, "windowMouse");
  createFileSystemGUI(90, 40, 75, 30, 6);

  background(250, 50);
  pg = createGraphics(1280, 700);


  fill(255, 95);
  // rect(10, 10, width, height);
  newFileSettings();
  graph(true);
}


//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
public void draw() {
}

public void pre() {
  if (currWidth != width || currHeight != height) {
    setSliders();
    graph(false);
    currWidth = width;
    currHeight = height;
  }
}


public void setBounds(){
  
  minXval = getUnix(0);
  maxXval = getUnix(table.getRowCount()-1);
  maxYval = 0;
  minYval = 100000;
  maxY2val = 0;
  minY2val = 150000;
  float mmf;
  float tmpT;

  for (int i=0; i < table.getRowCount (); i++) {
    if (mmCalc==true) {
      mmf =  table.getFloat(i, " Ch1")*100.0f/table.getFloat(i, " Ch4");
      ;
    } else {
      mmf = table.getFloat(i, mm);
    }
    mmf = mmf*1000;
    int mmi =(int)mmf;
    if (mmi < 1000) minYval=minYval;
    else if (mmi < minYval) minYval = mmi;
    else if (mmi > maxYval) maxYval = mmi;
  }

  for (int i=0; i < table.getRowCount (); i++) {
    if (tempTCalc==true) {
      tmpT =1.0f/((1.0f / 298.15f)+( 1.0f / 3974.0f ) * log( (table.getFloat(i, tempT)*10000.0f)/(table.getFloat(i, Ch4)-table.getFloat(i, tempT)) / 10000.0f ))-273.15f;
    } else {
      tmpT = table.getFloat(i, tempT);
    }
    tmpT = tmpT*1000;
    int tmpTI =(int)tmpT;
    if (tmpTI > 70000) minY2val=minY2val;
    else if (tmpTI < minY2val) minY2val = tmpTI;
    else if (tmpTI > maxY2val) maxY2val = tmpTI;
  }

  xSpan = maxXval - minXval;
  ySpan = maxYval - minYval;
  minYval = minYval - ySpan/20;
  maxYval = maxYval + ySpan/20;
  minXval = minXval - xSpan/50;
  maxXval = maxXval + xSpan/50;
  minY2val = minY2val - y2Span/8;
  maxY2val = maxY2val + y2Span/8;
  vminXval = minXval;
  vmaxXval = maxXval;
  vminYval = minYval;
  vmaxYval = maxYval;
  xSpan = maxXval - minXval;
  ySpan = maxYval - minYval;
  y2Span = maxY2val - minY2val;
  xvSpan =xSpan;
  yvSpan = ySpan;
  y2vSpan = y2Span;
} 
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------

public long getUnix(int Row) {

  String dateString = table.getString(Row, Date);
  String[] listA = split(dateString, '.');
  boolean fwdSlsh = false;
  if (listA[0] == "") {
    listA = split(dateString, '/');
    fwdSlsh = true;
    print('-');
  }
  dateString = table.getString(Row, Time);
  String HH = dateString.substring(1, 3);
  String[] listB = split(dateString, ':');

  int setMM;
  int setdd;

  int setYr = Integer.valueOf(listA[2])-1900;
  if (fwdSlsh == false) {
    setMM = Integer.valueOf(listA[1])-1;
    setdd = Integer.valueOf(listA[0]);
  } else {
    setMM = Integer.valueOf(listA[0])-1;
    setdd = Integer.valueOf(listA[1]);
  }
  int setHH = Integer.valueOf(HH)-1;
  int setmm = Integer.valueOf(listB[1]);
  int setss = Integer.valueOf(listB[2]);
  Date date = new Date(setYr, setMM, setdd, setHH, setmm, setss);
  long unixTime = date.getTime()/1000;
  return unixTime;
}
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
public void graph(boolean rstBnds) {
  clear();
  background(250, 50);
  if (rstBnds == true) {
    setBounds();
  }
  drawBckgnd();
  drawPoints();
  if (tempGraph==true) {
    drawPointsTemp();
  }
  sdr4.setVisible(tempGraph);
  sdr5.setVisible(tempGraph);

  image(img, 520, 6);
  text("TreeHugger CSV Viewer 3.2", 554, 90);
}

public void newFileSettings(){
  table = loadTable(fname, "header, csv");
  setColumnStringsmm();
  setColumnStringtempT();
  setColumnStringDate();
  setColumnStringTime();
  setSliders();
}


public void sliderShift() {
  vminXval = vminXval + xSpan*(sdr2.getValueI()-200)/400;
  vmaxXval = vmaxXval + xSpan*(sdr2.getValueI()-200)/400;
  vminYval = vminYval + ySpan*(sdr3.getValueI()-200)/400;
  vmaxYval = vmaxYval + ySpan*(sdr3.getValueI()-200)/400;
  vminY2val = vminY2val + ySpan*(sdr5.getValueI()-200)/400;
  vmaxY2val = vmaxY2val + ySpan*(sdr5.getValueI()-200)/400;
}

public void sliderZoom() { 
  vminXval = minXval+(xSpan/400)*sdr.getValueI();
  vmaxXval = maxXval-(xSpan/400)*sdr.getValueI();
  vminYval = minYval+(ySpan/400)*sdr1.getValueI();
  vmaxYval = maxYval-(ySpan/400)*sdr1.getValueI();
  vminY2val = minY2val+(y2Span/400)*sdr4.getValueI();
  vmaxY2val = maxY2val-(y2Span/400)*sdr4.getValueI();
  xvSpan = vmaxXval-vminXval;
  yvSpan = vmaxYval-vminYval;
  y2vSpan = vmaxY2val-vminY2val;
}

//frame.addComponentListener(new ComponentAdapter() {
//   public void componentResized(ComponentEvent e) {
//     int minHeight = 50;//your preferred minimum height
//     if(e.getSource()==frame) { if (frame.getHeight() < minHight) frame.setSize(frame.getWidth(), minHeight); }
//   }
// } );

  public void setSliders(){
  // Some of the following statements are not actually
  // required because they are setting the default value. 
    sdr.setVisible(false);
    sdr1.setVisible(false);
    sdr2.setVisible(false);
    sdr3.setVisible(false);
    sdr4.setVisible(false);
    sdr5.setVisible(false);
  sdr.setLocalColorScheme(6); 
  sdr.setOpaque(false); 
  sdr.setValue(0);
  sdr.setLimits(0, 199); 
  sdr.setNumberFormat(G4P.INTEGER, 200);
  sdr.setRotation(0.0f, GControlMode.CENTER);
  sdr.moveTo( width/2-100, height-40);
  sdr1.setLocalColorScheme(6); 
  sdr1.setOpaque(false); 
  sdr1.setValue(0);
  sdr1.setLimits(0, 199);
  sdr1.setNumberFormat(G4P.INTEGER, 200);
  sdr1.setRotation(PI*3/2, GControlMode.CORNER); 
  sdr1.moveTo( 20, height/2+100);
  sdr1.setLocalColorScheme(6); 
  sdr2.setOpaque(false); 
  sdr2.setLimits(0, 399);
  sdr2.setNumberFormat(G4P.INTEGER, 400);
  sdr2.setValue(200);
  sdr2.moveTo(width/2-400, height-20);
  sdr2.setRotation(0, GControlMode.CENTER);
  sdr3.setLocalColorScheme(6); 
  sdr3.setOpaque(false); 
  sdr3.setLimits(0, 399);
  sdr3.setNumberFormat(G4P.INTEGER, 400);
  sdr3.setValue(200);
  sdr3.setRotation(PI*3/2.00f, GControlMode.CORNER); 
  sdr3.moveTo(05, height/2+200);
  sdr4.setLocalColorScheme(6); 
  sdr4.setOpaque(false); 
  sdr4.setLimits(0, 199);
  sdr4.setNumberFormat(G4P.INTEGER, 200);
  sdr4.setValue(0);
  sdr4.setRotation(PI*3/2.00f, GControlMode.CORNER); 
  sdr4.moveTo(width-37, height/2+100);
  sdr5.setLocalColorScheme(6); 
  sdr5.setOpaque(false); 
  sdr5.setLimits(0, 399);
  sdr5.setNumberFormat(G4P.INTEGER, 400);
  sdr5.setValue(200);
  sdr5.setRotation(PI*3/2.00f, GControlMode.CORNER);
 sdr5.moveTo( width-20, height/2+200);
 sdr.setVisible(true);
    sdr1.setVisible(true);
    sdr2.setVisible(true);
    sdr3.setVisible(true);
}
public void drawBckgnd() {
  boolean shift = false;
  int tickMarks = 2;

  if (xvSpan < 7200) tickMarks=60;                 //Minute
  else if (xvSpan < 72000) tickMarks=1800;        //Half Hour
  else if (xvSpan < 140000) tickMarks=3600;        //Hour
  else if (xvSpan < 220000) tickMarks=21600;        //6Hour
  else if (xvSpan < 400000) tickMarks = 43200;     //12Hour
  else if (xvSpan < 2420000) tickMarks= 86400;     //Day
  else if (xvSpan < 12000000) tickMarks = 604800;   //Week
  else if (xvSpan < 32000000) tickMarks = 2592000;//30 Days
  else tickMarks = 220752000;                     //Year

  long temp = vminXval;
  textSize(12);
  stroke(0, 30);
  while ( temp <= vmaxXval) { 
    if ((temp-21600)%tickMarks==0) {
      long xPos = 90+(temp-vminXval)*(width-180)/xvSpan;
      fill(0);
      if (xPos > width-90) {
        break;
      }
      String date;

      if (tickMarks > 43400) {
        date = new java.text.SimpleDateFormat("dd/MM/yyyy").format(new java.util.Date ((temp-3600)*1000));
      } else {
        date = new java.text.SimpleDateFormat("HH:mm:ss").format(new java.util.Date ((temp-3600)*1000));
      }
      if (shift==true) {
        line(xPos, 95, xPos, height-65);
        text(date, xPos, height-55);
      } else {
        line(xPos, 95, xPos, height-55);
        text(date, xPos, height-45);
      }
      shift = !shift;
    } 
    temp = temp + 1;
  }
  temp = vmaxYval;
  int tickMarksv = 100;
  if (yvSpan < 1000) tickMarksv = 100;
  else if (yvSpan < 2500) tickMarksv = 250;
  else if (yvSpan < 5000) tickMarksv = 500;
  else if (yvSpan < 10000) tickMarksv = 1000;
  else if (yvSpan < 25000) tickMarksv = 2000;
  else if (yvSpan < 50000) tickMarksv = 5000;
  else tickMarksv = 10000;
  textSize(14);
  while (temp >= vminYval) {
    if (temp%tickMarksv==0) {

      long yPos = 95 + (vmaxYval-temp)*(height-160)/yvSpan;

      float tempF = (float)temp/1000;
      
        stroke(0,25);
      
       line(90, yPos, width-90, yPos);
      
      
        fill(0);
      
     text(String.format("%.2f", tempF), 43, yPos+4);
     }
    temp = temp-1;
  }
  if (tempGraph==true) {
    int tickMarksv2 = 100;
    if (y2vSpan < 1000) tickMarksv = 100;
    else if (y2vSpan < 2500) tickMarksv2 = 250;
    else if (y2vSpan < 5000) tickMarksv2 = 500;
    else if (y2vSpan < 10000) tickMarksv2 = 1000;
    else if (y2vSpan < 50000) tickMarksv2 = 5000;
    else if (y2vSpan < 100000) tickMarksv2 = 10000;
    else if (y2vSpan < 250000) tickMarksv2 = 25000;
    else tickMarksv2 = 50000;

    temp = vmaxY2val;
    stroke(0, 05);
    while (temp >= vminY2val) {
      if (temp%tickMarksv2==0) {

        long yPos = 95 + (vmaxY2val-temp)*(height-160)/y2vSpan;
        line(90, yPos, width-90, yPos);
        float tempF = (float)temp/1000;
        text(String.format("%.2f", tempF), width-81, yPos+4);
        //println(tempF);
      }
      temp = temp-1;
    }
  }
}
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
public void drawPoints() {

  int Rows = table.getRowCount();
  int temp = 0;
  long xOld=0;
  int yOld=0;
  float mmf;
  noSmooth();
  fill(0);
  stroke(0xff20CF60);
  strokeWeight(2);

  while (temp < Rows) {
    if (mmCalc==true) {
      mmf = table.getFloat(temp, mm)*100.0f/table.getFloat(temp, Ch4);
    } else {
      mmf = table.getFloat(temp, mm);
    }
    long unix = getUnix(temp);
    mmf = mmf*1000;
    int mm = (int)mmf;
    int yPos =  95 + (vmaxYval-mm)*(height-160)/yvSpan;
    long xPos = 90 + (unix-vminXval)*(width-180)/xvSpan;

    if (temp<1) {
      point(xPos, yPos);
    } else if (xPos>95) {
      if (yPos < 200) {
        stroke(0xff20CF60, (yPos*2)-150);
      } else if (yPos>height-140) {
        stroke(0xff20CF60, ((height-yPos)*2)-120);
      } else
      {
        stroke(0xff20CF60);
      }
      line(xPos, yPos, xOld, yOld);
    }
    xOld=xPos;
    yOld=yPos;
    //    print(xPos);
    //    print(' ');
    //    println(yPos);
    temp=temp+1;
    if (xPos > width-90) {
      break;
    }
  }
}

//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------

public void drawPointsTemp() {

  int Rows = table.getRowCount();
  int temp = 0;
  long xOld=0;
  int yOld=0;
  float excV;
  float tmpT;
  float tmp;
  noSmooth();
  fill(0);
  stroke(0xff852F00, 25);
  strokeWeight(2);

  while (temp < Rows) {
    tmp = table.getFloat(temp, tempT);
    excV = table.getFloat(temp, Ch4);
    if (tempTCalc==true) {
      tmpT =1.0f/((1.0f / 298.15f)+( 1.0f / 3974.0f ) * log( (tmp*10000.0f)/(excV-tmp) / 10000.0f ))-273.15f;
    } else {
      tmpT = tmp;
    }
    long unix = getUnix(temp);
    tmpT = tmpT*1000;
    int tmpTI = (int)tmpT;
    int yPos = 95 + (vmaxY2val-tmpTI)*(height-160)/y2vSpan;
    long xPos = 90 + (unix-vminXval)*(width-180)/xvSpan;

    if (temp<1) {
      point(xPos, yPos);
    } else if (xPos>95) {
      if (yPos < 100) {
        stroke(0xff852F00, (yPos*2)-150);
      } else if (yPos>height-70) {
        stroke(0xff852F00, ((height-yPos)*2)-120);
      } else
      {
        stroke(0xff852F00, 25);
      }
      line(xPos, yPos, xOld, yOld);
    }
    xOld=xPos;
    yOld=yPos;
    temp=temp+1;
    if (xPos > width-90) {
      break;
    }
  }
}
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------

/**
 * Handles mouse events for ALL GWindow objects
 *  
 * @param appc the PApplet object embeded into the frame
 * @param data the data for the GWindow being used
 * @param event the mouse event
 */
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
public void windowMouse(GWinApplet appc, GWinData data, MouseEvent event) {
  MyWinData data2 = (MyWinData)data;
  switch(event.getAction()) {
  case MouseEvent.PRESS:
    data2.sx = data2.ex = appc.mouseX;
    data2.sy = data2.ey = appc.mouseY;
    data2.done = false;
    break;
  case MouseEvent.RELEASE:
    data2.ex = appc.mouseX;
    data2.ey = appc.mouseY;
    data2.done = true;
    break;
  case MouseEvent.DRAG:
    data2.ex = appc.mouseX;
    data2.ey = appc.mouseY;
    break;
  }
}
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
/**
 * Click the button to create the windows.
 * @param button
 */
public void handleButtonEvents(GButton button, GEvent event) { 
  // Folder selection
  if (button == btnInput) {
    handleFileDialog(button);
  } else if (button == btnRst) {
    sdr.setValue(0);
    sdr1.setValue(0);
    sdr.setValue(0);
    sdr2.setValue(200);
    sdr3.setValue(200);
    sdr5.setValue(200);
    graph(true);
  } else if (button == btntemp) {
    //btntemp.setSelected(tempGraph);
    tempGraph = !tempGraph;
    graph(false);
  } else if (button == btnPNG) {
    saveFrame("TH_Screen-####.png");
  }
}

/**
 * Simple class that extends GWinData and holds the data 
 * that is specific to a particular window.
 * 
 * @author Peter Lager
 */
class MyWinData extends GWinData {
  int sx, sy, ex, ey;
  boolean done;
}

public void windowDraw(GWinApplet appc, GWinData data) {
  MyWinData data2 = (MyWinData)data;
  if (!(data2.sx == data2.ex && data2.ey == data2.ey)) {

    appc.stroke(0);
    appc.strokeWeight(2);
    appc.noFill();
    if (data2.done) {
      appc.fill(128);
    }
    appc.rectMode(CORNERS);
    appc.rect(data2.sx, data2.sy, data2.ex, data2.ey);
  }
} 
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
public void createFileSystemGUI(int x, int y, int w, int h, int border) {

  btnInput = new GButton(this, x, y, w, h, "Input");
  lblFile = new GLabel(this, x, y-28, w+300, 28);
  lblFile.setTextAlign(GAlign.LEFT, GAlign.MIDDLE);
  lblFile.setOpaque(true);
  lblFile.setLocalColorScheme(G4P.GREEN_SCHEME);
  btnRst = new GButton(this, x+75, y, w, h, "Reset");
  btntemp = new GButton(this, x+150, y, w, h, "Temp");
  lblFile.setText(fname);
  btnPNG = new GButton(this, x+225, y, w, h, "Exp PNG");
}


// G4P code for folder and file dialogs
public void handleFileDialog(GButton button) {

  // Folder selection
  if (button == btnInput) {
    // Use file filter if possible
    try {
      fname = G4P.selectInput("Input Dialog", "png,gif,jpg,jpeg", "Image files");

      fname = fname.replace("\\", "/");
      lblFile.setText(fname);
      newFileSettings();

      graph(true);
    } 
    catch (NullPointerException e) {
      fname=fname;
    }
  }
}

// G4P code for message dialogs
public void handleMessageDialog() {
  // Determine message type
  int mtype;
  switch(md_mtype) {
  default:
  case 0: 
    mtype = G4P.PLAIN; 
    break;
  case 1: 
    mtype = G4P.ERROR; 
    break;
  case 2: 
    mtype = G4P.INFO; 
    break;
  case 3: 
    mtype = G4P.WARNING; 
    break;
  case 4: 
    mtype = G4P.QUERY; 
    break;
  }
  String message = txfSMMessage.getText();
  String title = txfMdTitle.getText();
  G4P.showMessage(this, message, title, mtype);
}

public void handleSliderEvents(GValueControl slider, GEvent event) { 
  if (slider == sdr || slider == sdr1 || slider == sdr2 || slider == sdr3 || slider == sdr4 || slider == sdr5) {// The slider being configured?
    sliderZoom();
    sliderShift();
    graph(false);
  }
}
boolean zoomBox = false;

//void mouseWheel(MouseEvent event) {
//  int e = event.getCount();
//
//  if (sdr.getValueI()<60) {
//    sdr.setValue(4*e+sdr.getValueI());
//  } else if (sdr.getValueI()<80) {
//    sdr.setValue(3*e+sdr.getValueI());
//  } else if (sdr.getValueI()<90) {
//    sdr.setValue(2*e+sdr.getValueI());
//  } else {
//    sdr.setValue(e+sdr.getValueI());
//  }
//  graph(false);
//}

public void mousePressed() {
  if ((mouseX < width-90 && mouseX > 90)&&(mouseY<height-65&&mouseY>90)) {
    mx = mouseX;
    my = mouseY;
    zoomBox = true;
    loadPixels();
  }
}

public void mouseDragged() {
  if ((mouseX < width-90 && mouseX > 90)&&(mouseY<height-65&&mouseY>90)&&zoomBox==true) {
    pg.beginDraw();
    pg.background(255, 0);
    pg.stroke(0, 15);
    pg.rectMode(CORNERS);
    pg.fill(0xff20CF60, 20);
    pg.rect( mx, my, mouseX, mouseY);
    pg.endDraw();
    updatePixels();
    image(pg, 0, 0);
  }
}


public void mouseReleased() {
  if ((mouseX < width-90 && mouseX > 90)&&(mouseY<height-65&&mouseY>90)&&zoomBox==true) {
    if (mouseX>mx) {      
      vmaxXval = (((mouseX-90)*xvSpan)/(width-180))+vminXval;
      vminXval = (((mx-90)*xvSpan)/(width-180))+vminXval;
    } else {
      vmaxXval = ((mx-90)*xvSpan)/(width-180)+vminXval;
      vminXval = (mouseX-90)*(xvSpan)/(width-180)+vminXval;
    }
    if (mouseY<my) {
      vmaxYval = (((height-mouseY)-65)*yvSpan)/(height-160)+vminYval;
      vminYval = ((height-my-65)*yvSpan)/(height-160)+vminYval;
    } else {
      vmaxYval = ((height-my-65)*yvSpan)/(height-160)+vminYval;
      vminYval = (((height-mouseY)-65)*yvSpan)/(height-160)+vminYval;
    }
    xvSpan = vmaxXval-vminXval;
    yvSpan = vmaxYval-vminYval;

    sdr2.setValue(((xvSpan/2+vminXval)-minXval)*400/xSpan);
    sdr3.setValue(((yvSpan/2+vminYval)-minYval)*400/ySpan);
    sdr.setValue(200-(xvSpan*200/xSpan));
    sdr1.setValue(200-(yvSpan*200/ySpan));
    zoomBox = false;
  }
}

String str;
public void setColumnStringsmm() {

  try {
    F = table.getFloat(1, " mm" );
    mm = "";
    mm = " mm";
    mmCalc=false;
  }
  catch (Exception e) {
    try {
      F = table.getFloat(1, "mm" );
      mm = "";
      mm = "mm";
      mmCalc=false;
    }
    catch (Exception t) {
      try {
        F = table.getFloat(1, " Ch1");
        mm = "";
        mm = " Ch1";
        mmCalc=true;
      }
      catch (Exception r) {
        try {
          F = table.getFloat(1, " ch1");
          mm = "";
          mm = " ch1";
          mmCalc=true;
        }
        catch (Exception y) {
          try {
            F = table.getFloat(1, "ch1");
            mm = "";
            mm = "ch1";
            mmCalc=true;
          }
          catch (IllegalArgumentException w) {
            F = table.getFloat(1, "Ch1");
            mm = "";
            mm = "Ch1";
            mmCalc=true;
          }
        }
      }
    }
  }
}


public void setColumnStringtempT() {

  try {
    F = table.getFloat(1, " Temp" );
    tempT = "";
    tempT = " Temp";
    tempTCalc=false;
  }
  catch (Exception e) {
    try {
      F = table.getFloat(1, "Temp" );
      tempT = "";
      tempT = "Temp";
      tempTCalc=false;
    }
    catch (Exception t) {
      try {
        F = table.getFloat(1, " Ch2");
        tempT = "";
        tempT = " Ch2";
        Ch4 = " Ch4";
        tempTCalc=true;
      }
      catch (Exception r) {
        try {
          F = table.getFloat(1, " ch2");
          tempT = "";
          tempT = " ch2";
          Ch4 = " ch4";
          tempTCalc=true;
        }
        catch (Exception y) {
          try {
            F = table.getFloat(1, "ch2");
            tempT = "";
            tempT = "ch2";
            Ch4 = "ch4";
            tempTCalc=true;
          }
          catch (IllegalArgumentException w) {
            F = table.getFloat(1, "Ch2");
            tempT = "";
            tempT = "Ch2";
            Ch4 = "Ch4";
            tempTCalc=true;
          }
        }
      }
    }
  }
}

public void setColumnStringTime() {

  try {
    str = table.getString(1, " Time" );
    Time = "";
    Time = " Time";

  }
  catch (Exception e) {
    try {
      F = table.getFloat(1, "Time" );
      Time = "";
      Time = "Time";

    }
    catch (Exception t) {
      try {
        F = table.getFloat(1, " time");
        Time = "";
        Time = " time";

      }
      catch (Exception r) {

        F = table.getFloat(1, "time");
        Time = "";
        Time = "time";

      }
    }
  }
}

public void setColumnStringDate() {

  try {
    str = table.getString(1, " Date" );
    Date = "";
    Date = " Date";

  }
  catch (Exception e) {
    try {
      F = table.getFloat(1, "Date" );
      Date = "";
      Date = "Date";

    }
    catch (Exception t) {
      try {
        F = table.getFloat(1, " date");
        Date = "";
        Date = " date";

      }
      catch (Exception r) {

        F = table.getFloat(1, "date");
        Date = "";
        Date = "date";

      }
    }
  }
}

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "Graph" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
