void drawBckgnd() {
  boolean shift = false;
  int tickMarks = 2;

  if (xvSpan < 7200) tickMarks=60;                 //Minute
  else if (xvSpan < 72000) tickMarks=1800;        //Half Hour
  else if (xvSpan < 140000) tickMarks=3600;        //Hour
  else if (xvSpan < 220000) tickMarks=21600;        //6Hour
  else if (xvSpan < 400000) tickMarks = 43200;     //12Hour
  else if (xvSpan < 2420000) tickMarks= 86400;     //Day
  else if (xvSpan < 12000000) tickMarks = 604800;   //Week
  else if (xvSpan < 32000000) tickMarks = 2592000;//30 Days
  else tickMarks = 220752000;                     //Year

  long temp = vminXval;
  textSize(12);
  stroke(0, 30);
  while ( temp <= vmaxXval) { 
    if ((temp-21600)%tickMarks==0) {
      long xPos = 90+(temp-vminXval)*(width-180)/xvSpan;
      fill(0);
      if (xPos > width-90) {
        break;
      }
      String date;

      if (tickMarks > 43400) {
        date = new java.text.SimpleDateFormat("dd/MM/yyyy").format(new java.util.Date ((temp-3600)*1000));
      } else {
        date = new java.text.SimpleDateFormat("HH:mm:ss").format(new java.util.Date ((temp-3600)*1000));
      }
      if (shift==true) {
        line(xPos, 95, xPos, height-65);
        text(date, xPos, height-55);
      } else {
        line(xPos, 95, xPos, height-55);
        text(date, xPos, height-45);
      }
      shift = !shift;
    } 
    temp = temp + 1;
  }
  temp = vmaxYval;
  int tickMarksv = 100;
  if (yvSpan < 1000) tickMarksv = 100;
  else if (yvSpan < 2500) tickMarksv = 250;
  else if (yvSpan < 5000) tickMarksv = 500;
  else if (yvSpan < 10000) tickMarksv = 1000;
  else if (yvSpan < 25000) tickMarksv = 2000;
  else if (yvSpan < 50000) tickMarksv = 5000;
  else tickMarksv = 10000;
  textSize(14);
  while (temp >= vminYval) {
    if (temp%tickMarksv==0) {

      long yPos = 95 + (vmaxYval-temp)*(height-160)/yvSpan;

      float tempF = (float)temp/1000;
      
        stroke(0,25);
      
       line(90, yPos, width-90, yPos);
      
      
        fill(0);
      
     text(String.format("%.2f", tempF), 43, yPos+4);
     }
    temp = temp-1;
  }
  if (tempGraph==true) {
    int tickMarksv2 = 100;
    if (y2vSpan < 1000) tickMarksv = 100;
    else if (y2vSpan < 2500) tickMarksv2 = 250;
    else if (y2vSpan < 5000) tickMarksv2 = 500;
    else if (y2vSpan < 10000) tickMarksv2 = 1000;
    else if (y2vSpan < 50000) tickMarksv2 = 5000;
    else if (y2vSpan < 100000) tickMarksv2 = 10000;
    else if (y2vSpan < 250000) tickMarksv2 = 25000;
    else tickMarksv2 = 50000;

    temp = vmaxY2val;
    stroke(0, 05);
    while (temp >= vminY2val) {
      if (temp%tickMarksv2==0) {

        long yPos = 95 + (vmaxY2val-temp)*(height-160)/y2vSpan;
        line(90, yPos, width-90, yPos);
        float tempF = (float)temp/1000;
        text(String.format("%.2f", tempF), width-81, yPos+4);
        //println(tempF);
      }
      temp = temp-1;
    }
  }
}
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
void drawPoints() {

  int Rows = table.getRowCount();
  int temp = 0;
  long xOld=0;
  int yOld=0;
  float mmf;
  noSmooth();
  fill(0);
  stroke(#20CF60);
  strokeWeight(2);

  while (temp < Rows) {
    if (mmCalc==true) {
      mmf = table.getFloat(temp, mm)*100.0/table.getFloat(temp, Ch4);
    } else {
      mmf = table.getFloat(temp, mm);
    }
    long unix = getUnix(temp);
    mmf = mmf*1000;
    int mm = (int)mmf;
    int yPos =  95 + (vmaxYval-mm)*(height-160)/yvSpan;
    long xPos = 90 + (unix-vminXval)*(width-180)/xvSpan;

    if (temp<1) {
      point(xPos, yPos);
    } else if (xPos>95) {
      if (yPos < 200) {
        stroke(#20CF60, (yPos*2)-150);
      } else if (yPos>height-140) {
        stroke(#20CF60, ((height-yPos)*2)-120);
      } else
      {
        stroke(#20CF60);
      }
      line(xPos, yPos, xOld, yOld);
    }
    xOld=xPos;
    yOld=yPos;
    //    print(xPos);
    //    print(' ');
    //    println(yPos);
    temp=temp+1;
    if (xPos > width-90) {
      break;
    }
  }
}

//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------

void drawPointsTemp() {

  int Rows = table.getRowCount();
  int temp = 0;
  long xOld=0;
  int yOld=0;
  float excV;
  float tmpT;
  float tmp;
  noSmooth();
  fill(0);
  stroke(#852F00, 25);
  strokeWeight(2);

  while (temp < Rows) {
    tmp = table.getFloat(temp, tempT);
    excV = table.getFloat(temp, Ch4);
    if (tempTCalc==true) {
      tmpT =1.0/((1.0 / 298.15)+( 1.0 / 3974.0 ) * log( (tmp*10000.0)/(excV-tmp) / 10000.0 ))-273.15;
    } else {
      tmpT = tmp;
    }
    long unix = getUnix(temp);
    tmpT = tmpT*1000;
    int tmpTI = (int)tmpT;
    int yPos = 95 + (vmaxY2val-tmpTI)*(height-160)/y2vSpan;
    long xPos = 90 + (unix-vminXval)*(width-180)/xvSpan;

    if (temp<1) {
      point(xPos, yPos);
    } else if (xPos>95) {
      if (yPos < 100) {
        stroke(#852F00, (yPos*2)-150);
      } else if (yPos>height-70) {
        stroke(#852F00, ((height-yPos)*2)-120);
      } else
      {
        stroke(#852F00, 25);
      }
      line(xPos, yPos, xOld, yOld);
    }
    xOld=xPos;
    yOld=yPos;
    temp=temp+1;
    if (xPos > width-90) {
      break;
    }
  }
}
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------

