// The data path of the folder to look in (write your own)
java.io.File folder = new java.io.File(dataPath("E:/"));
import processing.serial.*;
import java.util.*;
import java.text.*;
import de.bezier.guido.*;
import g4p_controls.*;
import java.awt.Rectangle;
import java.util.ArrayList;

GSlider sdr;
GSlider sdr1;
GSlider sdr2;
GSlider sdr3;
GSlider sdr4;
GSlider sdr5;
GButton btnStart;
GLabel lblInstr;
PGraphics pg;

Table table;
Serial myPort;        // The serial port
long minXval;
long maxXval;
long vminXval;
long vmaxXval;
int minYval=100000;
int maxYval;
int minY2val=100000;
int maxY2val;
int vminYval=100000;
int vmaxYval;
int vminY2val=100000;
int vmaxY2val;
int mx, my, mx1, my1;
int currWidth, currHeight;
long xSpan;
long xvSpan;
int ySpan;
int y2Span;
int yvSpan;
int y2vSpan;
int zoomX1;
String mm;
String Ch4 = " Ch4";
String tempT;
String Time;
String Date;
float F;

int zoomY1;
boolean mouseClick = false;
boolean mmCalc = false;
boolean tempTCalc = false;
boolean tempGraph = false;

// Controls used for file dialog GUI 
PImage img;

GButton btnRst, btnInput, btntemp, btnPNG;
GLabel lblFile;
GCheckbox cbxUseNative;

// Graphic frames used to group controls
ArrayList<Rectangle> rects ;
int md_mtype;
GTextArea txfSMMessage;
GTextField txfMdTitle;
String fname = "../Example Data/010515.csv";

// let's set a filter (which returns true if file's extension is .csv)
java.io.FilenameFilter jpgFilter = new java.io.FilenameFilter() {
  boolean accept(File dir, String name) {
    return name.toLowerCase().endsWith(".csv");
  }
};

// list all the folders inside the main directory
String[] listFolders = folder.list(new java.io.FilenameFilter() {
  public boolean accept(File current, String name) {
    return new File(current, name).isFile();
  }
}
);

// list the files in the data folder, passing the filter as parameter
String[] filenames = folder.list(jpgFilter);
String[] foldernames = folder.list();

//// get and display the number of jpg files
//println(filenames.length + " csv files in specified directory");
//println(foldernames.length + " files in the specified directory");
// 
//// display the folder names
//for(int i=0; i < foldernames.length-1; i++) {
//  println(listFolders[i]);
//}
// 
//// display the filenames
//for (int i = 0; i < filenames.length; i++) {
//  println(filenames[i]);
//}

void setup() {

  // fname = G4P.selectInput("Input CSV File", "csv", "Data files");

  size(displayWidth, displayHeight-70);
  if (frame != null) {
    frame.setResizable(true);
  }
   registerMethod("pre", this);
  //btnStart = new GButton(this, 4, 34, 120, 60, "Create 3 Windows");
  lblInstr = new GLabel(this, 132, 34, 120, 60, "Use the mouse to draw a rectangle in any of the 3 windows");
  lblInstr.setTextAlign(GAlign.CENTER, GAlign.MIDDLE);
  lblInstr.setVisible(false);

  img = loadImage("GCS Logo.png");
  sdr = new GSlider(this, width/2-100, height-40, 200, 20, 15); 
  sdr1 = new GSlider(this, 20, height/2+100, 200, 20, 15);
  sdr4 = new GSlider(this, width-37, height/2, 200, 20, 15);
  sdr2 = new GSlider(this, width/2-400, height-20, 800, 15, 10); 
  sdr3 = new GSlider(this, 05, height/2+200, 400, 15, 10); 
  sdr5 = new GSlider(this, width-20, height/2+100, 400, 20, 10); 
  setSliders();
  rects = new ArrayList<Rectangle> ();
  //    window = new GWindow(this, "Window "+1, 70+1*220, 160+1*50, 200, 200, false, JAVA2D);
  //    window.setBackground(255);
  //    window.addData(new MyWinData());
  //    window.addDrawHandler(this, "windowDraw");
  //    window.addMouseHandler(this, "windowMouse");
  createFileSystemGUI(90, 40, 75, 30, 6);

  background(250, 50);
  pg = createGraphics(1280, 700);


  fill(255, 95);
  // rect(10, 10, width, height);
  newFileSettings();
  graph(true);
}


//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
void draw() {
}

void pre() {
  if (currWidth != width || currHeight != height) {
    setSliders();
    graph(false);
    currWidth = width;
    currHeight = height;
  }
}


void setBounds(){
  
  minXval = getUnix(0);
  maxXval = getUnix(table.getRowCount()-1);
  maxYval = 0;
  minYval = 100000;
  maxY2val = 0;
  minY2val = 150000;
  float mmf;
  float tmpT;

  for (int i=0; i < table.getRowCount (); i++) {
    if (mmCalc==true) {
      mmf =  table.getFloat(i, " Ch1")*100.0/table.getFloat(i, " Ch4");
      ;
    } else {
      mmf = table.getFloat(i, mm);
    }
    mmf = mmf*1000;
    int mmi =(int)mmf;
    if (mmi < 1000) minYval=minYval;
    else if (mmi < minYval) minYval = mmi;
    else if (mmi > maxYval) maxYval = mmi;
  }

  for (int i=0; i < table.getRowCount (); i++) {
    if (tempTCalc==true) {
      tmpT =1.0/((1.0 / 298.15)+( 1.0 / 3974.0 ) * log( (table.getFloat(i, tempT)*10000.0)/(table.getFloat(i, Ch4)-table.getFloat(i, tempT)) / 10000.0 ))-273.15;
    } else {
      tmpT = table.getFloat(i, tempT);
    }
    tmpT = tmpT*1000;
    int tmpTI =(int)tmpT;
    if (tmpTI > 70000) minY2val=minY2val;
    else if (tmpTI < minY2val) minY2val = tmpTI;
    else if (tmpTI > maxY2val) maxY2val = tmpTI;
  }

  xSpan = maxXval - minXval;
  ySpan = maxYval - minYval;
  minYval = minYval - ySpan/20;
  maxYval = maxYval + ySpan/20;
  minXval = minXval - xSpan/50;
  maxXval = maxXval + xSpan/50;
  minY2val = minY2val - y2Span/8;
  maxY2val = maxY2val + y2Span/8;
  vminXval = minXval;
  vmaxXval = maxXval;
  vminYval = minYval;
  vmaxYval = maxYval;
  xSpan = maxXval - minXval;
  ySpan = maxYval - minYval;
  y2Span = maxY2val - minY2val;
  xvSpan =xSpan;
  yvSpan = ySpan;
  y2vSpan = y2Span;
} 
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------

long getUnix(int Row) {

  String dateString = table.getString(Row, Date);
  String[] listA = split(dateString, '.');
  boolean fwdSlsh = false;
  if (listA[0] == "") {
    listA = split(dateString, '/');
    fwdSlsh = true;
    print('-');
  }
  dateString = table.getString(Row, Time);
  String HH = dateString.substring(1, 3);
  String[] listB = split(dateString, ':');

  int setMM;
  int setdd;

  int setYr = Integer.valueOf(listA[2])-1900;
  if (fwdSlsh == false) {
    setMM = Integer.valueOf(listA[1])-1;
    setdd = Integer.valueOf(listA[0]);
  } else {
    setMM = Integer.valueOf(listA[0])-1;
    setdd = Integer.valueOf(listA[1]);
  }
  int setHH = Integer.valueOf(HH)-1;
  int setmm = Integer.valueOf(listB[1]);
  int setss = Integer.valueOf(listB[2]);
  Date date = new Date(setYr, setMM, setdd, setHH, setmm, setss);
  long unixTime = date.getTime()/1000;
  return unixTime;
}
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
void graph(boolean rstBnds) {
  clear();
  background(250, 50);
  if (rstBnds == true) {
    setBounds();
  }
  drawBckgnd();
  drawPoints();
  if (tempGraph==true) {
    drawPointsTemp();
  }
  sdr4.setVisible(tempGraph);
  sdr5.setVisible(tempGraph);

  image(img, 520, 6);
  text("TreeHugger CSV Viewer 3.2", 554, 90);
}

void newFileSettings(){
  table = loadTable(fname, "header, csv");
  setColumnStringsmm();
  setColumnStringtempT();
  setColumnStringDate();
  setColumnStringTime();
  setSliders();
}


void sliderShift() {
  vminXval = vminXval + xSpan*(sdr2.getValueI()-200)/400;
  vmaxXval = vmaxXval + xSpan*(sdr2.getValueI()-200)/400;
  vminYval = vminYval + ySpan*(sdr3.getValueI()-200)/400;
  vmaxYval = vmaxYval + ySpan*(sdr3.getValueI()-200)/400;
  vminY2val = vminY2val + ySpan*(sdr5.getValueI()-200)/400;
  vmaxY2val = vmaxY2val + ySpan*(sdr5.getValueI()-200)/400;
}

void sliderZoom() { 
  vminXval = minXval+(xSpan/400)*sdr.getValueI();
  vmaxXval = maxXval-(xSpan/400)*sdr.getValueI();
  vminYval = minYval+(ySpan/400)*sdr1.getValueI();
  vmaxYval = maxYval-(ySpan/400)*sdr1.getValueI();
  vminY2val = minY2val+(y2Span/400)*sdr4.getValueI();
  vmaxY2val = maxY2val-(y2Span/400)*sdr4.getValueI();
  xvSpan = vmaxXval-vminXval;
  yvSpan = vmaxYval-vminYval;
  y2vSpan = vmaxY2val-vminY2val;
}

//frame.addComponentListener(new ComponentAdapter() {
//   public void componentResized(ComponentEvent e) {
//     int minHeight = 50;//your preferred minimum height
//     if(e.getSource()==frame) { if (frame.getHeight() < minHight) frame.setSize(frame.getWidth(), minHeight); }
//   }
// } );

