/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GConstants;
import g4p_controls.GConstantsInternal;
import g4p_controls.GWinApplet;
import java.util.Collections;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public class GWindowInfo
implements PConstants,
GConstants,
GConstantsInternal {
    public PApplet app;
    public boolean app_g_3d;
    public PMatrix orgMatrix;
    public LinkedList<GAbstractControl> windowControls = new LinkedList();
    public LinkedList<GAbstractControl> toRemove = new LinkedList();
    public LinkedList<GAbstractControl> toAdd = new LinkedList();
    boolean isGWindow;

    public GWindowInfo(PApplet pApplet) {
        this.app = pApplet;
        this.isGWindow = this.app instanceof GWinApplet;
        this.app_g_3d = this.app.g.is3D();
        if (this.app.g.is3D()) {
            this.orgMatrix = pApplet.getMatrix((PMatrix3D)null);
        }
        this.app.registerMethod("draw", (Object)this);
        this.app.registerMethod("mouseEvent", (Object)this);
        this.app.registerMethod("keyEvent", (Object)this);
        this.app.registerMethod("pre", (Object)this);
        this.app.registerMethod("post", (Object)this);
    }

    public void draw() {
        this.app.pushMatrix();
        if (this.app_g_3d) {
            this.app.hint(2);
            this.app.resetMatrix();
            this.app.applyMatrix(this.orgMatrix);
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 1) != 1) continue;
            gAbstractControl.draw();
        }
        if (this.app_g_3d) {
            this.app.hint(-2);
        }
        this.app.popMatrix();
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (this.isGWindow) {
            ((GWinApplet)this.app).mouseEvent(mouseEvent);
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 2) != 2) continue;
            gAbstractControl.mouseEvent(mouseEvent);
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (this.isGWindow) {
            ((GWinApplet)this.app).keyEvent(keyEvent);
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 8) != 8) continue;
            gAbstractControl.keyEvent(keyEvent);
        }
    }

    public void pre() {
        if (GAbstractControl.controlToTakeFocus != null && GAbstractControl.controlToTakeFocus.getPApplet() == this.app) {
            GAbstractControl.controlToTakeFocus.setFocus(true);
            GAbstractControl.controlToTakeFocus = null;
        }
        if (this.isGWindow) {
            ((GWinApplet)this.app).pre();
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 4) != 4) continue;
            gAbstractControl.pre();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post() {
        if (G4P.cursorChangeEnabled) {
            if (GAbstractControl.cursorIsOver != null) {
                this.app.cursor(GAbstractControl.cursorIsOver.cursorOver);
            } else {
                this.app.cursor(G4P.mouseOff);
            }
        }
        if (this.isGWindow) {
            ((GWinApplet)this.app).post();
        }
        for (GAbstractControl iterator : this.windowControls) {
            if ((iterator.registeredMethods & 0x10) != 16) continue;
            iterator.post();
        }
        GWindowInfo gWindowInfo = this;
        synchronized (gWindowInfo) {
            if (!this.toRemove.isEmpty()) {
                for (GAbstractControl gAbstractControl : this.toRemove) {
                    if (GAbstractControl.focusIsWith == gAbstractControl) {
                        gAbstractControl.loseFocus(null);
                    }
                    gAbstractControl.buffer = null;
                    if (gAbstractControl.parent != null) {
                        gAbstractControl.parent.children.remove(gAbstractControl);
                        gAbstractControl.parent = null;
                    }
                    if (gAbstractControl.children != null) {
                        gAbstractControl.children.clear();
                    }
                    gAbstractControl.palette = null;
                    gAbstractControl.jpalette = null;
                    gAbstractControl.eventHandlerObject = null;
                    gAbstractControl.eventHandlerMethod = null;
                    gAbstractControl.winApp = null;
                    this.windowControls.remove(gAbstractControl);
                    System.gc();
                }
                this.toRemove.clear();
            }
            if (!this.toAdd.isEmpty()) {
                for (GAbstractControl gAbstractControl : this.toAdd) {
                    this.windowControls.add(gAbstractControl);
                }
                this.toAdd.clear();
                Collections.sort(this.windowControls, G4P.zorder);
            }
        }
    }

    void dispose() {
        this.app.noLoop();
        this.app.unregisterMethod("draw", (Object)this);
        this.app.unregisterMethod("pre", (Object)this);
        this.app.unregisterMethod("post", (Object)this);
        this.app.unregisterMethod("mouseEvent", (Object)this);
        this.app.unregisterMethod("keyEvent", (Object)this);
        this.windowControls.clear();
    }

    synchronized void addControl(GAbstractControl gAbstractControl) {
        if (!this.windowControls.contains(gAbstractControl) && !this.toAdd.contains(gAbstractControl)) {
            this.toAdd.add(gAbstractControl);
        }
    }

    synchronized void removeControl(GAbstractControl gAbstractControl) {
        if (this.windowControls.contains(gAbstractControl) && !this.toRemove.contains(gAbstractControl)) {
            this.toRemove.add(gAbstractControl);
        }
    }

    void setColorScheme(int n) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.setLocalColorScheme(n);
        }
    }

    void setAlpha(int n) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.setAlpha(n);
        }
    }
}

