/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.GAbstractControl;
import g4p_controls.GEvent;
import g4p_controls.StyledString;
import processing.core.PApplet;

public abstract class GValueControl
extends GAbstractControl {
    protected StyledString ssStartLimit;
    protected StyledString ssEndLimit;
    protected StyledString ssValue;
    protected float startLimit = 0.0f;
    protected float endLimit = 1.0f;
    protected boolean showLimits = false;
    protected int valueType = 1;
    protected int precision = 2;
    protected String unit = "";
    protected boolean showValue = false;
    protected float parametricPos = 0.5f;
    protected float parametricTarget = 0.5f;
    protected float easing = 1.0f;
    protected int nbrTicks = 2;
    protected boolean stickToTicks = false;
    protected boolean showTicks = false;
    protected boolean limitsInvalid = true;
    protected float offset;

    public GValueControl(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
    }

    @Override
    public void pre() {
        if (Math.abs(this.parametricTarget - this.parametricPos) > epsilon) {
            this.parametricPos += (this.parametricTarget - this.parametricPos) / this.easing;
            this.updateDueToValueChanging();
            this.bufferInvalid = true;
            if (Math.abs(this.parametricTarget - this.parametricPos) > epsilon) {
                this.fireEvent(new Object[]{this, GEvent.VALUE_CHANGING});
            } else {
                this.parametricPos = this.parametricTarget;
                this.fireEvent(new Object[]{this, GEvent.VALUE_STEADY});
            }
        }
    }

    protected void updateDueToValueChanging() {
    }

    protected String getNumericDisplayString(float f) {
        String string = "";
        switch (this.valueType) {
            case 0: {
                string = String.format("%d %s", Math.round(f), this.unit);
                break;
            }
            case 1: {
                string = String.format("%." + this.precision + "f %s", Float.valueOf(f), this.unit);
                break;
            }
            case 2: {
                string = String.format("%." + this.precision + "e %s", Float.valueOf(f), this.unit);
            }
        }
        return string.trim();
    }

    public void setLimits(int n, int n2) {
        this.startLimit = n;
        this.endLimit = n2;
        this.setEpsilon();
        this.valueType = 0;
        this.limitsInvalid = true;
        this.bufferInvalid = true;
    }

    public void setLimits(int n, int n2, int n3) {
        this.startLimit = n2;
        this.endLimit = n3;
        this.valueType = 0;
        this.setEpsilon();
        this.limitsInvalid = true;
        this.bufferInvalid = true;
        this.setValue(n);
        this.parametricPos = this.parametricTarget;
        this.updateDueToValueChanging();
    }

    public void setLimits(float f, float f2) {
        this.startLimit = f;
        this.endLimit = f2;
        if (this.valueType == 0) {
            this.valueType = 1;
            this.setPrecision(1);
        }
        this.setEpsilon();
        this.limitsInvalid = true;
        this.bufferInvalid = true;
    }

    public void setLimits(float f, float f2, float f3) {
        this.startLimit = f2;
        this.endLimit = f3;
        f = PApplet.constrain((float)f, (float)f2, (float)f3);
        if (this.valueType == 0) {
            this.valueType = 1;
            this.setPrecision(1);
        }
        this.setEpsilon();
        this.limitsInvalid = true;
        this.bufferInvalid = true;
        this.setValue(f);
        this.parametricPos = this.parametricTarget;
        this.updateDueToValueChanging();
    }

    public void setValue(float f) {
        if (this.valueType == 0) {
            f = Math.round(f);
        }
        float f2 = (f - this.startLimit) / (this.endLimit - this.startLimit);
        f2 = PApplet.constrain((float)f2, (float)0.0f, (float)1.0f);
        if (this.stickToTicks) {
            f2 = this.findNearestTickValueTo(f2);
        }
        this.parametricTarget = f2;
    }

    public void setPrecision(int n) {
        if ((n = PApplet.constrain((int)n, (int)1, (int)5)) < 1) {
            n = 1;
        }
        if (n != this.precision) {
            this.precision = n;
            this.setEpsilon();
            this.limitsInvalid = true;
            this.bufferInvalid = true;
        }
    }

    protected void setEpsilon() {
        epsilon = (float)Math.min(0.001, Math.pow(10.0, -this.precision));
    }

    public void setUnits(String string) {
        if (string == null) {
            string = "";
        }
        if (!this.unit.equals(string)) {
            this.unit = string;
            this.limitsInvalid = true;
            this.bufferInvalid = true;
        }
    }

    public void setNumberFormat(int n, int n2, String string) {
        this.unit = string == null ? "" : string;
        this.setNumberFormat(n, n2);
    }

    public void setNumberFormat(int n, int n2) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.valueType = n;
                break;
            }
            default: {
                this.valueType = 1;
            }
        }
        this.setPrecision(n2);
        this.bufferInvalid = true;
    }

    public void setNumberFormat(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.valueType = n;
                break;
            }
            default: {
                this.valueType = 1;
            }
        }
        this.bufferInvalid = true;
    }

    public float getValueF() {
        return this.startLimit + (this.endLimit - this.startLimit) * this.parametricPos;
    }

    public int getValueI() {
        return Math.round(this.startLimit + (this.endLimit - this.startLimit) * this.parametricPos);
    }

    public String getValueS() {
        return this.getNumericDisplayString(this.getValueF());
    }

    public float getEasing() {
        return this.easing;
    }

    public void setEasing(float f) {
        this.easing = f < 1.0f ? 1.0f : f;
    }

    public int getNbrTicks() {
        return this.nbrTicks;
    }

    public void setNbrTicks(int n) {
        if (n < 2) {
            n = 2;
        }
        if (this.nbrTicks != n) {
            this.nbrTicks = n;
            this.bufferInvalid = true;
            if (this.stickToTicks) {
                this.parametricTarget = this.findNearestTickValueTo(this.parametricPos);
            }
        }
    }

    public boolean isStickToTicks() {
        return this.stickToTicks;
    }

    public void setStickToTicks(boolean bl) {
        this.stickToTicks = bl;
        if (bl) {
            this.setShowTicks(true);
            this.parametricTarget = this.findNearestTickValueTo(this.parametricPos);
            this.bufferInvalid = true;
        }
    }

    protected float findNearestTickValueTo(float f) {
        float f2 = 1.0f / (float)(this.nbrTicks - 1);
        int n = (int)(f / f2 + 0.5f);
        return f2 * (float)n;
    }

    public boolean isShowTicks() {
        return this.showTicks;
    }

    public void setShowTicks(boolean bl) {
        if (this.showTicks != bl) {
            this.showTicks = bl;
            this.bufferInvalid = true;
        }
    }

    public boolean isShowLimits() {
        return this.showLimits;
    }

    public void setShowLimits(boolean bl) {
        this.showLimits = bl;
        this.bufferInvalid = true;
    }

    public boolean isShowValue() {
        return this.showValue;
    }

    public void setShowValue(boolean bl) {
        this.showValue = bl;
        this.bufferInvalid = true;
    }

    public void setShowDecor(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setShowValue(bl3);
        this.bufferInvalid = true;
        this.setOpaque(bl);
        this.setShowTicks(bl2);
        this.setShowLimits(bl4);
    }

    public float getStartLimit() {
        return this.startLimit;
    }

    public float getEndLimit() {
        return this.endLimit;
    }

    public int getValueType() {
        return this.valueType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getUnit() {
        return this.unit;
    }
}

