/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.GEvent;
import g4p_controls.GTextIconAlignBase;
import g4p_controls.GToggleGroup;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public abstract class GToggleControl
extends GTextIconAlignBase {
    protected GToggleGroup group = null;
    protected boolean selected = false;

    public GToggleControl(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
        this.opaque = false;
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(1, 0.0f, 0.0f, this.width, this.height)};
    }

    protected void setToggleGroup(GToggleGroup gToggleGroup) {
        this.group = gToggleGroup;
    }

    public GToggleGroup getToggleGroup() {
        return this.group;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        if (this.selected != bl) {
            this.bufferInvalid = true;
        }
        if (bl && this.group != null) {
            this.group.makeSelected(this);
        }
        this.selected = bl;
    }

    protected void hasBeenClicked() {
        if (this.group == null) {
            this.selected = !this.selected;
            this.bufferInvalid = true;
        } else if (!this.selected) {
            this.setSelected(true);
        }
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot < 0 || this.z <= GToggleControl.focusObjectZ()) break;
                this.dragging = false;
                this.takeFocus();
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                this.hasBeenClicked();
                this.loseFocus(null);
                if (this.selected) {
                    this.fireEvent(new Object[]{this, GEvent.SELECTED});
                    break;
                }
                if (this.group != null) break;
                this.fireEvent(new Object[]{this, GEvent.DESELECTED});
                break;
            }
            case 4: {
                this.dragging = true;
                break;
            }
            case 2: {
                if (focusIsWith == this && this.dragging) {
                    this.loseFocus(null);
                }
                this.dragging = false;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            Graphics2D graphics2D = this.buffer.g2;
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            this.buffer.background(this.opaque ? this.palette[6] : this.palette[2] & 0xFFFFFF);
            this.calcAlignment();
            if (this.iconW != 0) {
                if (this.selected) {
                    this.buffer.image(this.bicon[1], (float)this.siX, (float)this.siY);
                } else {
                    this.buffer.image(this.bicon[0], (float)this.siX, (float)this.siY);
                }
            }
            float f = this.stext.getWrapWidth();
            float f2 = 0.0f;
            float f3 = 0.0f;
            this.buffer.translate(this.stX, this.stY);
            for (StyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                switch (this.textAlignH) {
                    case CENTER: {
                        f3 = textLayout.getAdvance();
                        f3 = f3 > f ? f3 - f : f3;
                        f2 = (f - f3) / 2.0f;
                        break;
                    }
                    case RIGHT: {
                        f3 = textLayout.getAdvance();
                        f3 = f3 > f ? f3 - f : f3;
                        f2 = f - f3;
                        break;
                    }
                    default: {
                        f2 = 0.0f;
                    }
                }
                graphics2D.setColor(this.jpalette[2]);
                textLayoutInfo.layout.draw(graphics2D, f2, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            this.buffer.endDraw();
        }
    }
}

