/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.GAlign;
import g4p_controls.GTextAlign;
import g4p_controls.ImageManager;
import g4p_controls.StyledString;
import processing.core.PApplet;
import processing.core.PImage;

public abstract class GTextIconAlignBase
extends GTextAlign {
    protected PImage[] bicon = null;
    protected int iconW = 0;
    protected int iconH = 0;
    protected GAlign iconAlignH = GAlign.RIGHT;
    protected GAlign iconAlignV = GAlign.MIDDLE;
    protected int siX;
    protected int siY;

    public GTextIconAlignBase(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
    }

    @Override
    public void setText(String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        this.stext = this.iconW == 0 ? new StyledString(string, (int)this.width - 4) : new StyledString(string, (int)this.width - this.iconW - 8);
        this.bufferInvalid = true;
    }

    public void setIcon(String string, int n, GAlign gAlign, GAlign gAlign2) {
        PImage pImage = ImageManager.loadImage(this.winApp, string);
        this.setIcon(pImage, n, gAlign, gAlign2);
    }

    public void setIcon(PImage pImage, int n, GAlign gAlign, GAlign gAlign2) {
        if (pImage != null) {
            if (n == 3) {
                this.bicon = ImageManager.makeTiles1D(this.winApp, pImage, n, 1);
            } else {
                this.bicon = new PImage[3];
                PImage[] pImageArray = ImageManager.makeTiles1D(this.winApp, pImage, n, 1);
                System.arraycopy(pImageArray, 0, this.bicon, 0, pImageArray.length);
                for (int i = pImageArray.length; i < 3; ++i) {
                    this.bicon[i] = this.bicon[i - 1];
                }
            }
            if (gAlign != null && gAlign.isHorzAlign() && gAlign != GAlign.CENTER) {
                this.iconAlignH = gAlign;
            }
            if (gAlign2 != null && gAlign2.isVertAlign()) {
                this.iconAlignV = gAlign2;
            }
            this.iconW = this.bicon[0].width;
            this.iconH = this.bicon[0].height;
            this.stext.setWrapWidth((int)this.width - this.iconW - 8);
            this.bufferInvalid = true;
        }
    }

    public void setIconAlign(GAlign gAlign, GAlign gAlign2) {
        if (this.iconW != 0) {
            if (gAlign != null && gAlign.isHorzAlign() && gAlign != GAlign.CENTER) {
                this.iconAlignH = gAlign;
            }
            if (gAlign2 != null && gAlign2 != null && gAlign2.isVertAlign()) {
                this.iconAlignV = gAlign2;
            }
            this.bufferInvalid = true;
        }
    }

    public void setHeightToFit() {
        if (this.stext != null && this.buffer != null) {
            this.stext.getLines(this.buffer.g2);
            int n = Math.round(this.stext.getTextAreaHeight());
            n = Math.max(n, this.iconH);
            int n2 = Math.round(this.width);
            this.resize(n2, n);
            this.calcAlignment();
            this.bufferInvalid = true;
        }
    }

    @Override
    protected void calcAlignment() {
        super.calcAlignment();
        if (this.iconW != 0) {
            switch (this.iconAlignH) {
                case LEFT: {
                    this.siX = 2;
                    if (this.textAlignH == GAlign.RIGHT) break;
                    this.stX += (float)(this.iconW + 4);
                    break;
                }
                default: {
                    this.siX = (int)this.width - this.iconW - 4;
                    if (this.textAlignH != GAlign.RIGHT) break;
                    this.stX -= (float)(this.iconW + 4);
                }
            }
            switch (this.iconAlignV) {
                case TOP: {
                    this.siY = 2;
                    break;
                }
                case BOTTOM: {
                    this.siY = (int)this.height - this.iconH - 4;
                    break;
                }
                default: {
                    this.siY = (int)(this.height - (float)this.iconH) / 2;
                }
            }
        }
    }

    @Override
    public String toString() {
        return this.tag;
    }
}

