/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GEvent;
import g4p_controls.GLinearTrackControl;
import g4p_controls.GValueControl;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import processing.core.PApplet;

public class GSlider
extends GLinearTrackControl {
    protected RoundRectangle2D track;
    static int DBORDER = 1;
    static int LBORDER = 3;
    static int BACK = 6;
    static int TBORDER = 15;
    static int TOFF = 3;
    static int TOVER = 11;
    static int TDOWN = 14;
    static int TDRAG = 15;

    public GSlider(PApplet pApplet, float f, float f2, float f3, float f4, float f5) {
        super(pApplet, f, f2, f3, f4);
        this.trackWidth = f5;
        this.trackDisplayLength = this.width - 2.0f * TINSET;
        this.trackLength = this.trackDisplayLength - this.trackWidth;
        this.track = new RoundRectangle2D.Float(-this.trackDisplayLength / 2.0f, -this.trackWidth / 2.0f, this.trackDisplayLength, this.trackWidth, this.trackWidth, this.trackWidth);
        this.trackOffset = this.calcTrackOffset();
        this.buffer.g2.setFont(G4P.numericLabelFont);
        this.hotspots = new HotSpot[]{new HotSpot.HScircle(THUMB_SPOT, this.width / 2.0f + (this.parametricPos - 0.5f) * this.trackLength, this.height / 2.0f, this.trackWidth / 2.0f), new HotSpot.HSrect(TRACK_SPOT, (this.width - this.trackLength) / 2.0f, (this.height - this.trackWidth) / 2.0f, this.trackLength, this.trackWidth)};
        this.z = 24;
        epsilon = 0.98f / this.trackLength;
        this.ssStartLimit = new StyledString("0.00");
        this.ssEndLimit = new StyledString("1.00");
        this.ssValue = new StyledString("0.50");
        this.createEventHandler(G4P.sketchApplet, "handleSliderEvents", new Class[]{GValueControl.class, GEvent.class}, new String[]{"slider", "event"});
        this.registeredMethods = 7;
        this.cursorOver = 12;
        G4P.addControl(this);
    }

    @Override
    protected void updateDueToValueChanging() {
        this.hotspots[0].x = this.width / 2.0f + (this.parametricPos - 0.5f) * this.trackLength;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.status = 0;
        }
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            Graphics2D graphics2D = this.buffer.g2;
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            this.buffer.rectMode(3);
            this.buffer.ellipseMode(3);
            this.buffer.background(this.opaque ? this.palette[6] : this.palette[2] & 0xFFFFFF);
            this.buffer.pushMatrix();
            this.buffer.translate(this.width / 2.0f, this.height / 2.0f);
            if (this.showTicks) {
                float f = 1.0f / (float)(this.nbrTicks - 1);
                for (int i = 0; i < this.nbrTicks; ++i) {
                    float f2 = ((float)i * f - 0.5f) * this.trackLength;
                    this.buffer.strokeWeight(2.0f);
                    this.buffer.stroke(this.palette[4]);
                    this.buffer.line(f2, -this.trackWidth, f2, this.trackWidth);
                    this.buffer.strokeWeight(1.2f);
                    this.buffer.stroke(this.palette[1]);
                    this.buffer.line(f2, -this.trackWidth, f2, this.trackWidth);
                }
            }
            graphics2D.setColor(this.jpalette[5]);
            graphics2D.fill(this.track);
            switch (this.status) {
                case 0: {
                    this.buffer.fill(this.palette[TOFF]);
                    break;
                }
                case 1: {
                    this.buffer.fill(this.palette[TOVER]);
                    break;
                }
                case 2: {
                    this.buffer.fill(this.palette[TDOWN]);
                    break;
                }
                case 3: {
                    this.buffer.fill(this.palette[TDRAG]);
                }
            }
            this.buffer.noStroke();
            this.buffer.ellipse((this.parametricPos - 0.5f) * this.trackLength, 0.0f, this.trackWidth, this.trackWidth);
            graphics2D.setStroke(pen_2_0);
            graphics2D.setColor(this.jpalette[3]);
            graphics2D.draw(this.track);
            graphics2D.setColor(this.jpalette[2]);
            if (this.labels != null) {
                this.drawLabels();
            } else {
                if (this.showLimits) {
                    this.drawLimits();
                }
                if (this.showValue) {
                    this.drawValue();
                }
            }
            this.buffer.popMatrix();
            this.buffer.endDraw();
        }
    }
}

