/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GEvent;
import g4p_controls.GLinearTrackControl;
import g4p_controls.GValueControl;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.io.File;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class GCustomSlider
extends GLinearTrackControl {
    protected PImage leftEnd;
    protected PImage thumb;
    protected PImage thumb_mouseover;
    protected PImage rightEnd;
    protected PImage centre;

    public GCustomSlider(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, null);
    }

    public GCustomSlider(PApplet pApplet, float f, float f2, float f3, float f4, String string) {
        super(pApplet, f, f2, f3, f4);
        string = string == null ? "grey_blue" : string.trim();
        this.setStyle(string);
        this.buffer.g2.setFont(G4P.numericLabelFont);
        this.buffer.imageMode(3);
        this.hotspots = new HotSpot[]{new HotSpot.HSalpha(THUMB_SPOT, this.width / 2.0f + (this.parametricPos - 0.5f) * this.trackLength, this.height / 2.0f, this.thumb, 3), new HotSpot.HSrect(TRACK_SPOT, (this.width - this.trackLength) / 2.0f, (this.height - this.trackWidth) / 2.0f, this.trackLength, this.trackWidth)};
        this.opaque = false;
        this.z = 24;
        epsilon = 0.98f / this.trackLength;
        this.ssStartLimit = new StyledString("0.00");
        this.ssEndLimit = new StyledString("1.00");
        this.ssValue = new StyledString("0.50");
        this.createEventHandler(G4P.sketchApplet, "handleSliderEvents", new Class[]{GValueControl.class, GEvent.class}, new String[]{"slider", "event"});
        this.registeredMethods = 7;
        this.cursorOver = 12;
        G4P.addControl(this);
    }

    public void setStyle(String string) {
        this.loadSkin(string);
        float f = Math.max(this.leftEnd.width, this.rightEnd.width);
        f = Math.max(f, 10.0f);
        this.trackLength = Math.round(this.width - 2.0f * f - TINSET);
        this.trackDisplayLength = this.trackLength + (float)(2 * Math.min(this.leftEnd.width, this.rightEnd.width));
        this.trackWidth = this.centre.height;
        this.trackOffset = this.calcTrackOffset();
        this.extendCentreImage();
        this.bufferInvalid = true;
    }

    @Override
    protected float calcTrackOffset() {
        float f = this.showTicks ? this.trackWidth : this.trackWidth / 2.0f;
        if ((f = Math.max(f, (float)(this.thumb.height / 2)) + 2.0f) != this.trackOffset) {
            this.bufferInvalid = true;
        }
        return f;
    }

    @Override
    protected void updateDueToValueChanging() {
        this.hotspots[0].x = this.width / 2.0f + (this.parametricPos - 0.5f) * this.trackLength;
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            Graphics2D graphics2D = this.buffer.g2;
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            this.buffer.background(this.opaque ? this.palette[6] : this.palette[2] & 0xFFFFFF);
            this.buffer.pushMatrix();
            this.buffer.translate(this.width / 2.0f, this.height / 2.0f);
            if (this.showTicks) {
                float f = 1.0f / (float)(this.nbrTicks - 1);
                for (int i = 0; i < this.nbrTicks; ++i) {
                    float f2 = Math.round(((float)i * f - 0.5f) * this.trackLength);
                    this.buffer.strokeWeight(2.0f);
                    this.buffer.stroke(255);
                    this.buffer.line(f2 + 1.0f, -this.trackWidth, f2 + 1.0f, this.trackWidth);
                    this.buffer.strokeWeight(1.0f);
                    this.buffer.stroke(0);
                    this.buffer.line(f2, -this.trackWidth, f2, this.trackWidth);
                }
            }
            this.buffer.image(this.centre, 0.0f, 0.0f);
            this.buffer.image(this.leftEnd, -(this.trackLength + (float)this.leftEnd.width) / 2.0f, 0.0f);
            this.buffer.image(this.rightEnd, (this.trackLength + (float)this.rightEnd.width) / 2.0f, 0.0f);
            switch (this.status) {
                case 0: {
                    this.buffer.image(this.thumb, (this.parametricPos - 0.5f) * this.trackLength, 0.0f);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.buffer.image(this.thumb_mouseover, (this.parametricPos - 0.5f) * this.trackLength, 0.0f);
                }
            }
            graphics2D.setColor(this.jpalette[2]);
            if (this.labels != null) {
                this.drawLabels();
            } else {
                if (this.showLimits) {
                    this.drawLimits();
                }
                if (this.showValue) {
                    this.drawValue();
                }
            }
            this.buffer.popMatrix();
            this.buffer.endDraw();
        }
    }

    private void extendCentreImage() {
        int n = (int)this.trackLength;
        PGraphics pGraphics = this.winApp.createGraphics(n, this.centre.height, "processing.core.PGraphicsJava2D");
        int n2 = n % this.centre.width;
        int n3 = n / this.centre.width;
        n3 = n2 == 0 ? n3 : n3 + 1;
        pGraphics.beginDraw();
        pGraphics.background(this.winApp.color(255, 0));
        pGraphics.imageMode(0);
        for (int i = (n - this.centre.width * n3) / 2; i < n; i += this.centre.width) {
            pGraphics.image(this.centre, (float)i, 0.0f);
        }
        pGraphics.endDraw();
        this.centre = pGraphics;
    }

    private void loadSkin(String string) {
        String string2 = string;
        boolean bl = false;
        bl = this.winApp.sketchPath("").length() == 0 ? this.loadSkin_AppletInBrowser(string) : this.loadStyle_FromSketch(string);
        if (!bl) {
            string2 = this.loadStyle_FromG4P(string);
        }
        if (!string.equalsIgnoreCase(string2)) {
            System.out.println("Unable to load the skin " + string + " using default '" + "grey_blue" + "' style instead");
        }
    }

    private String loadStyle_FromG4P(String string) {
        boolean bl;
        boolean bl2 = bl = "|grey_blue|blue18px|green_red20px|purple18px|red_yellow18px|".indexOf("|" + string + "|") >= 0;
        if (!bl) {
            string = "grey_blue";
        }
        this.leftEnd = this.winApp.loadImage(string + "/end_left.png");
        this.rightEnd = this.winApp.loadImage(string + "/end_right.png");
        this.thumb = this.winApp.loadImage(string + "/handle.png");
        this.thumb_mouseover = this.winApp.loadImage(string + "/handle_mouseover.png");
        this.centre = this.winApp.loadImage(string + "/centre.png");
        return string;
    }

    private boolean loadStyle_FromSketch(String string) {
        File file = new File(this.winApp.dataPath(string));
        if (!file.exists()) {
            file = new File(this.winApp.sketchPath(string));
        }
        if (!file.exists()) {
            return false;
        }
        int n = 0;
        String[] stringArray = new String[]{"centre.", "end_left.", "end_right.", "handle.", "handle_mouseover."};
        PImage[] pImageArray = new PImage[stringArray.length];
        File[] fileArray = file.listFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            for (File file2 : fileArray) {
                String string2 = file2.getName();
                if (!string2.startsWith(stringArray[i])) continue;
                pImageArray[i] = this.winApp.loadImage(string + "/" + string2);
                ++n;
            }
        }
        if (n != stringArray.length) {
            return false;
        }
        this.centre = pImageArray[0];
        this.leftEnd = pImageArray[1];
        this.rightEnd = pImageArray[2];
        this.thumb = pImageArray[3];
        this.thumb_mouseover = pImageArray[4];
        return true;
    }

    private boolean loadSkin_AppletInBrowser(String string) {
        boolean bl;
        this.leftEnd = this.winApp.loadImage(string + "/end_left.png");
        if (this.leftEnd == null) {
            this.leftEnd = this.winApp.loadImage(string + "/end_left.jpg");
        }
        this.rightEnd = this.winApp.loadImage(string + "/end_right.png");
        if (this.rightEnd == null) {
            this.rightEnd = this.winApp.loadImage(string + "/end_right.jpg");
        }
        this.thumb = this.winApp.loadImage(string + "/handle.png");
        if (this.thumb == null) {
            this.thumb = this.winApp.loadImage(string + "/handle.jpg");
        }
        this.thumb_mouseover = this.winApp.loadImage(string + "/handle_mouseover.png");
        if (this.thumb_mouseover == null) {
            this.thumb_mouseover = this.winApp.loadImage(string + "/handle_mouseover.jpg");
        }
        this.centre = this.winApp.loadImage(string + "/centre.png");
        if (this.centre == null) {
            this.centre = this.winApp.loadImage(string + "/centre.jpg");
        }
        boolean bl2 = bl = this.leftEnd != null && this.rightEnd != null && this.thumb != null && this.thumb_mouseover != null && this.centre != null;
        if (!bl) {
            System.out.println("Unable to load the skin " + string + " check the ");
            System.out.println("skin name used and ensure all the image files are present.");
            System.out.println("Reverting to default 'grey_blue' style");
            this.loadSkin("grey_blue");
        }
        return bl;
    }
}

