/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GEvent;
import g4p_controls.GTextIconAlignBase;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GButton
extends GTextIconAlignBase {
    protected int status = 0;
    protected boolean reportAllButtonEvents = false;

    public GButton(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, "");
    }

    public GButton(PApplet pApplet, float f, float f2, float f3, float f4, String string) {
        super(pApplet, f, f2, f3, f4);
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(1, 0.0f, 0.0f, this.width, this.height)};
        this.setText(string);
        this.z = 24;
        this.createEventHandler(G4P.sketchApplet, "handleButtonEvents", new Class[]{GButton.class, GEvent.class}, new String[]{"button", "event"});
        this.registeredMethods = 3;
        this.cursorOver = 12;
        G4P.addControl(this);
    }

    public void fireAllEvents(boolean bl) {
        this.reportAllButtonEvents = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.status = 0;
        }
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot < 0 || this.z <= GButton.focusObjectZ()) break;
                this.dragging = false;
                this.status = 2;
                this.takeFocus();
                if (this.reportAllButtonEvents) {
                    this.fireEvent(new Object[]{this, GEvent.PRESSED});
                }
                this.bufferInvalid = true;
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                this.status = 0;
                this.bufferInvalid = true;
                this.loseFocus(null);
                this.dragging = false;
                this.fireEvent(new Object[]{this, GEvent.CLICKED});
                break;
            }
            case 2: {
                if (focusIsWith != this || !this.dragging) break;
                if (this.reportAllButtonEvents) {
                    this.fireEvent(new Object[]{this, GEvent.RELEASED});
                }
                this.dragging = false;
                this.loseFocus(null);
                this.status = 0;
                this.bufferInvalid = true;
                break;
            }
            case 5: {
                int n = this.status;
                this.status = this.currSpot >= 0 ? 1 : 0;
                if (n == this.status) break;
                this.bufferInvalid = true;
                break;
            }
            case 4: {
                this.dragging = focusIsWith == this;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            Graphics2D graphics2D = this.buffer.g2;
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            switch (this.status) {
                case 1: {
                    this.buffer.background(this.palette[6]);
                    break;
                }
                case 2: {
                    this.buffer.background(this.palette[14]);
                    break;
                }
                default: {
                    this.buffer.background(this.palette[4]);
                }
            }
            graphics2D.setColor(this.jpalette[3]);
            graphics2D.setStroke(pen_1_0);
            graphics2D.drawRect(0, 0, (int)this.width - 1, (int)this.height - 1);
            this.calcAlignment();
            if (this.iconW != 0) {
                this.buffer.image(this.bicon[this.status], (float)this.siX, (float)this.siY);
            }
            float f = this.stext.getWrapWidth();
            float f2 = 0.0f;
            float f3 = 0.0f;
            this.buffer.translate(this.stX, this.stY);
            for (StyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                switch (this.textAlignH) {
                    case CENTER: {
                        f3 = textLayout.getVisibleAdvance();
                        f3 = f3 > f ? f3 - f : f3;
                        f2 = (f - f3) / 2.0f;
                        break;
                    }
                    case RIGHT: {
                        f3 = textLayout.getVisibleAdvance();
                        f3 = f3 > f ? f3 - f : f3;
                        f2 = f - f3;
                        break;
                    }
                    default: {
                        f2 = 0.0f;
                    }
                }
                graphics2D.setColor(this.jpalette[2]);
                textLayoutInfo.layout.draw(graphics2D, f2, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            this.buffer.endDraw();
        }
    }
}

