/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

public enum GAlign {
    INVALID(-1, "INVALID", "Invalid alignment"),
    LEFT(0, "LEFT", "Align left"),
    CENTER(1, "CENTER", "Align centre horizontally"),
    RIGHT(2, "RIGHT", "Align right"),
    JUSTIFY(3, "JUSTIFY", "Justify text"),
    TOP(16, "TOP", "Align top"),
    MIDDLE(17, "MIDDLE", "Align middle vertically"),
    BOTTOM(18, "BOTTOM", "Align bottom");

    private int alignID;
    private String alignText;
    private String description;

    public static GAlign getFromID(int n) {
        switch (n) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return CENTER;
            }
            case 2: {
                return RIGHT;
            }
            case 3: {
                return JUSTIFY;
            }
            case 16: {
                return TOP;
            }
            case 17: {
                return MIDDLE;
            }
            case 18: {
                return BOTTOM;
            }
        }
        return INVALID;
    }

    public static GAlign getFromText(String string) {
        if ((string = string.toUpperCase()).equals("LEFT")) {
            return LEFT;
        }
        if (string.equals("CENTER")) {
            return CENTER;
        }
        if (string.equals("RIGHT")) {
            return RIGHT;
        }
        if (string.equals("JUSTIFY")) {
            return JUSTIFY;
        }
        if (string.equals("TOP")) {
            return TOP;
        }
        if (string.equals("MIDDLE")) {
            return MIDDLE;
        }
        if (string.equals("BOTTOM")) {
            return BOTTOM;
        }
        return INVALID;
    }

    private GAlign(int n2, String string2, String string3) {
        this.alignID = n2;
        this.alignText = string2;
        this.description = string3;
    }

    public int getID() {
        return this.alignID;
    }

    public String getTextID() {
        return this.alignText;
    }

    public String getDesc() {
        return this.description;
    }

    public boolean isHorzAlign() {
        return this.alignID >= 0 && this.alignID <= 8;
    }

    public boolean isVertAlign() {
        return this.alignID >= 16;
    }

    public String toString() {
        return this.alignText;
    }
}

