/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.ColorPreviewPanel;
import g4p_controls.FileChooserFilter;
import g4p_controls.FilenameChooserFilter;
import g4p_controls.FontManager;
import g4p_controls.GAbstractControl;
import g4p_controls.GConstants;
import g4p_controls.GControlMode;
import g4p_controls.GWinApplet;
import g4p_controls.GWindow;
import g4p_controls.GWindowCloser;
import g4p_controls.GWindowInfo;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import processing.core.PApplet;
import processing.core.PConstants;

public class G4P
implements GConstants,
PConstants {
    static PApplet sketchApplet = null;
    public static GWindowCloser windowCloser = null;
    static int globalColorScheme = 6;
    static int globalAlpha = 255;
    static Font globalFont = FontManager.getPriorityFont(null, 0, 12);
    static Font numericLabelFont = FontManager.getPriorityFont(null, 1, 11);
    static HashMap<PApplet, GWindowInfo> windows = new HashMap();
    static GAbstractControl.Z_Order zorder = new GAbstractControl.Z_Order();
    static boolean cursorChangeEnabled = true;
    static int mouseOff = 0;
    static boolean showMessages = true;
    static GControlMode control_mode = GControlMode.CORNER;
    static LinkedList<G4Pstyle> styles = new LinkedList();
    static JColorChooser chooser = null;
    static Color lastColor = Color.white;
    private static String PANE_TEXT_STYLE_MACOS = "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" } p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head> <b>@@TITLE@@</b> <p>@@MESSAGE@@</p>";
    private static String PANE_TEXT_STYLE_OTHER = "<html> <head> <style type=\"text/css\">b { font: 12pt \"Lucida Grande\" } p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head> <b>@@MESSAGE@@ </b>";

    public static String getPrettyVersion() {
        return "3.5";
    }

    public static String getVersion() {
        return "18";
    }

    public static void registerSketch(PApplet pApplet) {
        if (sketchApplet == null) {
            sketchApplet = pApplet;
            G4P.announceG4P();
            GWindowInfo gWindowInfo = windows.get(pApplet);
            if (gWindowInfo == null) {
                gWindowInfo = new GWindowInfo(pApplet);
                windows.put(pApplet, gWindowInfo);
            }
        }
    }

    public static void setGlobalColorScheme(int n) {
        if (globalColorScheme != (n = Math.abs(n) % 16)) {
            globalColorScheme = n;
            for (GWindowInfo gWindowInfo : windows.values()) {
                gWindowInfo.setColorScheme(globalColorScheme);
            }
        }
    }

    public static void usePre35Fonts() {
        globalFont = new Font("Dialog", 0, 10);
        numericLabelFont = new Font("DialogInput", 1, 12);
    }

    public static void setWindowColorScheme(PApplet pApplet, int n) {
        n = Math.abs(n) % 16;
        GWindowInfo gWindowInfo = windows.get(pApplet);
        if (gWindowInfo != null) {
            gWindowInfo.setColorScheme(n);
        }
    }

    public static void setWindowColorScheme(GWindow gWindow, int n) {
        n = Math.abs(n) % 16;
        GWindowInfo gWindowInfo = windows.get(gWindow.papplet);
        if (gWindowInfo != null) {
            gWindowInfo.setColorScheme(n);
        }
    }

    public static void setGlobalAlpha(int n) {
        if (globalAlpha != (n = Math.abs(n) % 256)) {
            globalAlpha = n;
            for (GWindowInfo gWindowInfo : windows.values()) {
                gWindowInfo.setAlpha(globalAlpha);
            }
        }
    }

    public static void setWindowAlpha(PApplet pApplet, int n) {
        n = Math.abs(n) % 256;
        GWindowInfo gWindowInfo = windows.get(pApplet);
        if (gWindowInfo != null) {
            gWindowInfo.setAlpha(n);
        }
    }

    public static void setWindowAlpha(GWindow gWindow, int n) {
        n = Math.abs(n) % 256;
        GWindowInfo gWindowInfo = windows.get(gWindow.papplet);
        if (gWindowInfo != null) {
            gWindowInfo.setAlpha(n);
        }
    }

    static void addWindow(GWindow gWindow) {
        GWinApplet gWinApplet = gWindow.papplet;
        GWindowInfo gWindowInfo = windows.get(gWinApplet);
        if (gWindowInfo == null) {
            gWindowInfo = new GWindowInfo(gWinApplet);
            windows.put(gWinApplet, gWindowInfo);
        }
        if (windowCloser == null) {
            windowCloser = new GWindowCloser();
            sketchApplet.registerMethod("post", (Object)windowCloser);
        }
    }

    static void markWindowForClosure(GWindow gWindow) {
        windowCloser.addWindow(gWindow);
    }

    static void announceG4P() {
        System.out.println("===================================================");
        System.out.println("   G4P V3.5 created by Peter Lager");
        System.out.println("===================================================");
    }

    static void addControl(GAbstractControl gAbstractControl) {
        PApplet pApplet = gAbstractControl.getPApplet();
        GWindowInfo gWindowInfo = windows.get(pApplet);
        if (gWindowInfo == null) {
            gWindowInfo = new GWindowInfo(pApplet);
            windows.put(pApplet, gWindowInfo);
        }
        gWindowInfo.addControl(gAbstractControl);
    }

    static boolean removeControl(GAbstractControl gAbstractControl) {
        PApplet pApplet = gAbstractControl.getPApplet();
        GWindowInfo gWindowInfo = windows.get(pApplet);
        if (gWindowInfo != null) {
            gWindowInfo.removeControl(gAbstractControl);
            return true;
        }
        return false;
    }

    public static void setCtrlMode(GControlMode gControlMode) {
        if (gControlMode != null) {
            control_mode = gControlMode;
        }
    }

    public static GControlMode getCtrlMode() {
        return control_mode;
    }

    public static void messagesEnabled(boolean bl) {
        showMessages = bl;
    }

    public static void setMouseOverEnabled(boolean bl) {
        cursorChangeEnabled = bl;
    }

    @Deprecated
    public static void setCursorOff(int n) {
        mouseOff = n;
    }

    public static void setCursor(int n) {
        mouseOff = n;
        for (GWindowInfo gWindowInfo : windows.values()) {
            gWindowInfo.app.cursor(n);
        }
    }

    @Deprecated
    public static void setCursor(int n, GWindow gWindow) {
        G4P.setCursor(n, gWindow.papplet);
    }

    @Deprecated
    public static void setCursor(int n, PApplet pApplet) {
        GWindowInfo gWindowInfo = windows.get(pApplet);
        if (gWindowInfo != null) {
            mouseOff = n;
            gWindowInfo.app.cursor(n);
        }
    }

    public static int getCursor() {
        return mouseOff;
    }

    @Deprecated
    public static int getCursorOff() {
        return mouseOff;
    }

    static void pushStyle() {
        G4Pstyle g4Pstyle = new G4Pstyle();
        g4Pstyle.ctrlMode = control_mode;
        g4Pstyle.showMessages = showMessages;
        styles.addLast(g4Pstyle);
    }

    static void popStyle() {
        G4Pstyle g4Pstyle = styles.removeLast();
        control_mode = g4Pstyle.ctrlMode;
        showMessages = g4Pstyle.showMessages;
    }

    public static ArrayList<GWindow> getOpenWindowsAsList(ArrayList<GWindow> arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        } else {
            arrayList.clear();
        }
        Collection<GWindowInfo> collection = windows.values();
        for (GWindowInfo gWindowInfo : collection) {
            if (!gWindowInfo.isGWindow) continue;
            arrayList.add(((GWinApplet)gWindowInfo.app).owner);
        }
        return arrayList;
    }

    public static GWindow[] getOpenWindowsAsArray() {
        ArrayList<GWindow> arrayList = G4P.getOpenWindowsAsList(null);
        return arrayList.toArray(new GWindow[arrayList.size()]);
    }

    public static boolean isWindowOpen(GWindow gWindow) {
        if (gWindow != null) {
            ArrayList<GWindow> arrayList = G4P.getOpenWindowsAsList(null);
            return arrayList.contains(gWindow);
        }
        return false;
    }

    public static int selectColor() {
        Object object;
        Frame frame;
        Frame frame2 = frame = sketchApplet == null ? null : G4P.sketchApplet.frame;
        if (chooser == null) {
            chooser = new JColorChooser();
            object = chooser.getChooserPanels();
            LinkedList<AbstractColorChooserPanel> linkedList = new LinkedList<AbstractColorChooserPanel>();
            for (AbstractColorChooserPanel abstractColorChooserPanel : object) {
                String string = abstractColorChooserPanel.getDisplayName().toLowerCase();
                if (string.equals("swatches")) {
                    linkedList.addLast(abstractColorChooserPanel);
                    continue;
                }
                if (string.equals("rgb")) {
                    linkedList.addFirst(abstractColorChooserPanel);
                    continue;
                }
                if (!string.startsWith("hs")) continue;
                linkedList.addFirst(abstractColorChooserPanel);
            }
            AbstractColorChooserPanel[] abstractColorChooserPanelArray = linkedList.toArray(new AbstractColorChooserPanel[linkedList.size()]);
            chooser.setChooserPanels(abstractColorChooserPanelArray);
            ColorPreviewPanel colorPreviewPanel = new ColorPreviewPanel(lastColor);
            chooser.getSelectionModel().addChangeListener(colorPreviewPanel);
            chooser.setPreviewPanel(colorPreviewPanel);
        }
        ((ColorPreviewPanel)chooser.getPreviewPanel()).setPrevColor(lastColor);
        chooser.setColor(lastColor);
        object = JColorChooser.createDialog(frame, "Color picker", true, chooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                lastColor = chooser.getColor();
            }
        }, null);
        ((Dialog)object).setVisible(true);
        return lastColor.getRGB();
    }

    public static String selectFolder(String string) {
        Frame frame;
        String string2 = null;
        Frame frame2 = frame = sketchApplet == null ? null : G4P.sketchApplet.frame;
        if (PApplet.platform == 2 && PApplet.useNativeSelect) {
            FileDialog fileDialog = new FileDialog(frame, string, 0);
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String string3 = fileDialog.getFile();
            if (string3 != null) {
                try {
                    string2 = new File(fileDialog.getDirectory(), fileDialog.getFile()).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(frame);
            if (n == 0) {
                try {
                    string2 = jFileChooser.getSelectedFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        }
        return string2;
    }

    public static String selectInput(String string) {
        return G4P.selectInput(string, null, null);
    }

    public static String selectInput(String string, String string2, String string3) {
        return G4P.selectImpl(string, 0, string2, string3);
    }

    public static String selectOutput(String string) {
        return G4P.selectOutput(string, null, null);
    }

    public static String selectOutput(String string, String string2, String string3) {
        return G4P.selectImpl(string, 1, string2, string3);
    }

    private static String selectImpl(String string, int n, String string2, String string3) {
        Frame frame;
        String string4 = null;
        Frame frame2 = frame = sketchApplet == null ? null : G4P.sketchApplet.frame;
        if (PApplet.useNativeSelect) {
            FileDialog fileDialog = new FileDialog(frame, string, n);
            FilenameChooserFilter filenameChooserFilter = null;
            if (string2 != null && string2.length() > 0) {
                filenameChooserFilter = new FilenameChooserFilter(string2);
                fileDialog.setFilenameFilter(filenameChooserFilter);
            }
            fileDialog.setVisible(true);
            String string5 = fileDialog.getDirectory();
            if (string5 != null && (string4 = fileDialog.getFile()) != null) {
                try {
                    string4 = new File(string5, string4).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string4 = null;
                }
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(string);
            FileChooserFilter fileChooserFilter = null;
            if (string2 != null && string2.length() > 0) {
                fileChooserFilter = new FileChooserFilter(string2, string3);
                jFileChooser.setFileFilter(fileChooserFilter);
            }
            int n2 = -1;
            if (n == 1) {
                n2 = jFileChooser.showSaveDialog(frame);
            } else if (n == 0) {
                n2 = jFileChooser.showOpenDialog(frame);
            }
            if (n2 == 0) {
                try {
                    string4 = jFileChooser.getSelectedFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    string4 = null;
                }
            }
        }
        return string4;
    }

    public static void showMessage(Object object, String string, String string2, int n) {
        String string3;
        Frame frame = G4P.getFrame(object);
        if (PApplet.platform == 2) {
            string3 = PANE_TEXT_STYLE_MACOS.replaceAll("@@TITLE@@", string2);
            string2 = "";
            string3 = string3.replaceAll("@@MESSAGE@@", string);
        } else {
            string3 = PANE_TEXT_STYLE_OTHER.replaceAll("@@MESSAGE@@", string);
        }
        JOptionPane.showMessageDialog(frame, string3, string2, n);
    }

    public static int selectOption(Object object, String string, String string2, int n, int n2) {
        String string3;
        Frame frame = G4P.getFrame(object);
        if (PApplet.platform == 2) {
            string3 = PANE_TEXT_STYLE_MACOS.replaceAll("@@TITLE@@", string2);
            string2 = "";
            string3 = string3.replaceAll("@@MESSAGE@@", string);
        } else {
            string3 = PANE_TEXT_STYLE_OTHER.replaceAll("@@MESSAGE@@", string);
        }
        return JOptionPane.showOptionDialog(frame, string3, string2, n2, n, null, null, null);
    }

    private static Frame getFrame(Object object) {
        Frame frame = null;
        if (object instanceof PApplet || object instanceof GWinApplet) {
            frame = ((PApplet)object).frame;
        } else if (object instanceof GWindow) {
            frame = (Frame)object;
        } else if (object instanceof GAbstractControl) {
            frame = ((GAbstractControl)object).getPApplet().frame;
        }
        return frame;
    }

    static class G4Pstyle {
        GControlMode ctrlMode;
        boolean showMessages;

        G4Pstyle() {
        }
    }
}

