/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.guido;

import de.bezier.guido.AbstractActiveElement;
import de.bezier.guido.EventBinding;
import de.bezier.guido.ReflectiveActiveElement;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import processing.core.PApplet;
import processing.event.MouseEvent;

public class Interactive
implements MouseWheelListener {
    private boolean enabled = true;
    ArrayList<AbstractActiveElement> interActiveElements;
    private ArrayList<AbstractActiveElement> interActiveElementsList;
    static Interactive manager;
    PApplet papplet;
    static HashMap<String, ArrayList<EventBinding>> eventBindings;
    static Method emitMethod;

    private Interactive(PApplet pApplet) {
        this.papplet = pApplet;
        pApplet.registerMethod("mouseEvent", (Object)this);
        this.addMouseWheelListener();
        pApplet.registerMethod("draw", (Object)this);
    }

    private void addMouseWheelListener() {
        new Thread(){
            int runs = 0;

            @Override
            public void run() {
                ++this.runs;
                if (Interactive.manager.papplet.frame != null) {
                    Interactive.manager.papplet.frame.addMouseWheelListener(manager);
                    return;
                }
                try {
                    Thread.sleep(1000L);
                    if (this.runs < 10) {
                        this.run();
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }.start();
    }

    public static Interactive make(PApplet pApplet) {
        if (manager == null) {
            manager = new Interactive(pApplet);
        }
        return manager;
    }

    public static Interactive get() {
        if (manager == null) {
            System.err.println("You need to initialize me first with ...\n\n\tInteractive.make(this);\n");
        }
        return manager;
    }

    public static void setActive(Object object, boolean bl) {
        if (manager != null) {
            for (AbstractActiveElement abstractActiveElement : Interactive.manager.interActiveElements) {
                if (abstractActiveElement.getClass().equals(ReflectiveActiveElement.class)) {
                    if (((ReflectiveActiveElement)abstractActiveElement).listener != object) continue;
                    abstractActiveElement.setActive(bl);
                    continue;
                }
                if (abstractActiveElement != object) continue;
                abstractActiveElement.setActive(bl);
            }
        }
    }

    public static boolean insideRect(float f, float f2, float f3, float f4, float f5, float f6) {
        return f5 >= f && f5 <= f + f3 && f6 >= f2 && f6 <= f2 + f4;
    }

    public static AbstractActiveElement add(Object object) {
        if (manager == null) {
            System.err.println("You need to call Interactive.make() first.");
            return null;
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz != AbstractActiveElement.class) continue;
            return null;
        }
        ReflectiveActiveElement reflectiveActiveElement = new ReflectiveActiveElement(object);
        return reflectiveActiveElement;
    }

    public static void add(Object[] objectArray) {
        for (Object object : objectArray) {
            Interactive.add(object);
        }
    }

    public static void set(Object object, String string, Object object2) {
        Field field;
        if (object == null || string == null || object2 == null) {
            System.err.println("Interactive.set() ... a value is null!");
        }
        if ((field = Interactive.getField(object, string, object2)) != null) {
            try {
                field.set(object, object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static Field getField(Object object, String string, Object object2) {
        Field[] fieldArray;
        Class<?> clazz = object2.getClass();
        for (Field field : fieldArray = object.getClass().getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(clazz) || !field.getName().equals(string)) continue;
            return field;
        }
        System.err.println("Interactive.set() ... unable to find a field with that name in given target");
        return null;
    }

    public static void on(String string, Object object, String string2) {
        Interactive.on(null, string, object, string2);
    }

    public static void on(Object[] objectArray, String string, Object object, String string2) {
        for (Object object2 : objectArray) {
            Interactive.on(object2, string, object, string2);
        }
    }

    public static void on(Object object, String string, Object object2, String string2) {
        Object object3;
        Method method = null;
        try {
            for (Method method2 : object3 = object2.getClass().getDeclaredMethods()) {
                if (!method2.getName().equals(string2)) continue;
                method = method2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (method != null) {
            ArrayList<EventBinding> arrayList;
            object3 = EventBinding.getIdFor(object, string);
            EventBinding eventBinding = new EventBinding(string, object2, method);
            if (eventBindings == null) {
                eventBindings = new HashMap();
            }
            if ((arrayList = eventBindings.get(object3)) == null) {
                arrayList = new ArrayList();
                eventBindings.put((String)object3, arrayList);
            }
            arrayList.add(eventBinding);
        } else {
            System.err.println("Sorry, that method named " + string2 + " could not be found ... ");
        }
    }

    public static void send(String string, Object ... objectArray) {
        if (emitMethod == null) {
            try {
                emitMethod = Interactive.class.getDeclaredMethod("send", Object.class, String.class, Object[].class);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            emitMethod.invoke(null, null, string, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void send(Object object, String string, Object ... objectArray) {
        if (eventBindings == null) {
            System.err.println("No bindings exist at the moment");
            return;
        }
        String string2 = EventBinding.getIdFor(object, string);
        ArrayList<EventBinding> arrayList = eventBindings.get(string2);
        if (arrayList != null) {
            for (EventBinding eventBinding : arrayList) {
                if (eventBinding == null) continue;
                eventBinding.send(objectArray);
            }
        }
    }

    public static boolean isActive() {
        if (manager != null) {
            return manager.isEnabled();
        }
        return false;
    }

    public static void toggle() {
        if (manager != null) {
            manager.setEnabled(!manager.isEnabled());
        }
    }

    public static void deactivate() {
        if (manager != null) {
            manager.setEnabled(false);
        }
    }

    public static void activate() {
        if (manager != null) {
            manager.setEnabled(true);
        }
    }

    public static void setActive(boolean bl) {
        if (manager != null) {
            manager.setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.enabled) {
            return;
        }
        if (this.interActiveElements == null) {
            return;
        }
        this.mouseWheelMovedImpl(mouseWheelEvent.getWheelRotation());
    }

    private void mouseWheelMovedImpl(float f) {
        if (!this.enabled) {
            return;
        }
        if (this.interActiveElements == null) {
            return;
        }
        this.updateListenerList();
        for (AbstractActiveElement abstractActiveElement : this.interActiveElementsList) {
            if (!abstractActiveElement.isActive()) continue;
            abstractActiveElement.mouseScrolled(f);
            float f2 = this.papplet.mouseX;
            float f3 = this.papplet.mouseY;
            boolean bl = abstractActiveElement.hover;
            abstractActiveElement.hover = abstractActiveElement.isInside(f2, f3);
            if (abstractActiveElement.hover && !bl) {
                abstractActiveElement.mouseEntered();
                abstractActiveElement.mouseEntered(f2, f3);
                continue;
            }
            if (abstractActiveElement.hover || !bl) continue;
            abstractActiveElement.mouseExited();
            abstractActiveElement.mouseExited(f2, f3);
        }
        this.clearListenerList();
    }

    private void updateListenerList() {
        if (this.interActiveElements == null) {
            System.err.println("Trying to build event-list but source list is empty");
            return;
        }
        if (this.interActiveElementsList == null) {
            this.interActiveElementsList = new ArrayList(this.interActiveElements.size());
            this.interActiveElementsList.addAll(this.interActiveElements);
        }
    }

    private void clearListenerList() {
        this.interActiveElementsList = null;
    }

    public void addElement(AbstractActiveElement abstractActiveElement) {
        if (this.interActiveElements == null) {
            this.interActiveElements = new ArrayList();
        }
        if (!this.interActiveElements.contains(abstractActiveElement)) {
            this.interActiveElements.add(abstractActiveElement);
        }
    }

    public void draw() {
        if (!this.enabled) {
            return;
        }
        if (this.interActiveElements == null) {
            return;
        }
        this.updateListenerList();
        for (AbstractActiveElement abstractActiveElement : this.interActiveElementsList) {
            if (!abstractActiveElement.isActive()) continue;
            abstractActiveElement.draw();
        }
        this.clearListenerList();
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return;
        }
        if (this.interActiveElements == null) {
            return;
        }
        this.updateListenerList();
        switch (mouseEvent.getAction()) {
            case 6: {
                this.mouseEntered(mouseEvent);
                break;
            }
            case 5: {
                this.mouseMoved(mouseEvent);
                break;
            }
            case 1: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 4: {
                this.mouseDragged(mouseEvent);
                break;
            }
            case 2: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 3: {
                break;
            }
            case 7: {
                this.mouseExited(mouseEvent);
                break;
            }
            case 8: {
                this.mouseWheelMovedImpl(mouseEvent.getAmount());
            }
        }
        this.clearListenerList();
    }

    private void mouseEntered(MouseEvent mouseEvent) {
    }

    private void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (AbstractActiveElement abstractActiveElement : this.interActiveElementsList) {
            if (!abstractActiveElement.isActive()) continue;
            boolean bl = abstractActiveElement.hover;
            abstractActiveElement.hover = abstractActiveElement.isInside(n, n2);
            if (abstractActiveElement.hover && !bl) {
                abstractActiveElement.mouseEntered();
                abstractActiveElement.mouseEntered(n, n2);
                continue;
            }
            if (!abstractActiveElement.hover && bl) {
                abstractActiveElement.mouseExited();
                abstractActiveElement.mouseExited(n, n2);
                continue;
            }
            abstractActiveElement.mouseMoved();
            abstractActiveElement.mouseMoved(n, n2);
        }
    }

    private void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (AbstractActiveElement abstractActiveElement : this.interActiveElementsList) {
            if (!abstractActiveElement.isActive() || !abstractActiveElement.hover) continue;
            abstractActiveElement.mousePressedPre(n, n2);
        }
    }

    private void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (AbstractActiveElement abstractActiveElement : this.interActiveElementsList) {
            if (!abstractActiveElement.isActive() || !abstractActiveElement.hover) continue;
            abstractActiveElement.mouseDraggedPre(n, n2);
        }
    }

    private void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (AbstractActiveElement abstractActiveElement : this.interActiveElementsList) {
            if (!abstractActiveElement.isActive() || !abstractActiveElement.hover) continue;
            abstractActiveElement.mouseReleasedPre(n, n2);
            abstractActiveElement.mouseReleasedPost(n, n2);
        }
    }

    private void mouseExited(MouseEvent mouseEvent) {
    }
}

