/*
 * Decompiled with CFR 0.152.
 */
import g4p_controls.G4P;
import g4p_controls.GAlign;
import g4p_controls.GButton;
import g4p_controls.GCheckbox;
import g4p_controls.GControlMode;
import g4p_controls.GEvent;
import g4p_controls.GLabel;
import g4p_controls.GSlider;
import g4p_controls.GTextArea;
import g4p_controls.GTextField;
import g4p_controls.GValueControl;
import g4p_controls.GWinApplet;
import g4p_controls.GWinData;
import java.awt.Rectangle;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.data.Table;
import processing.event.MouseEvent;
import processing.serial.Serial;

public class Graph
extends PApplet {
    File folder = new File(this.dataPath("E:/"));
    GSlider sdr;
    GSlider sdr1;
    GSlider sdr2;
    GSlider sdr3;
    GSlider sdr4;
    GSlider sdr5;
    GButton btnStart;
    GLabel lblInstr;
    PGraphics pg;
    Table table;
    Serial myPort;
    long minXval;
    long maxXval;
    long vminXval;
    long vmaxXval;
    int minYval = 100000;
    int maxYval;
    int minY2val = 100000;
    int maxY2val;
    int vminYval = 100000;
    int vmaxYval;
    int vminY2val = 100000;
    int vmaxY2val;
    int mx;
    int my;
    int mx1;
    int my1;
    int currWidth;
    int currHeight;
    long xSpan;
    long xvSpan;
    int ySpan;
    int y2Span;
    int yvSpan;
    int y2vSpan;
    int zoomX1;
    String mm;
    String Ch4 = " Ch4";
    String tempT;
    String Time;
    String Date;
    float F;
    int zoomY1;
    boolean mouseClick = false;
    boolean mmCalc = false;
    boolean tempTCalc = false;
    boolean tempGraph = false;
    PImage img;
    GButton btnRst;
    GButton btnInput;
    GButton btntemp;
    GButton btnPNG;
    GLabel lblFile;
    GCheckbox cbxUseNative;
    ArrayList<Rectangle> rects;
    int md_mtype;
    GTextArea txfSMMessage;
    GTextField txfMdTitle;
    String fname = "../Example Data/010515.csv";
    FilenameFilter jpgFilter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".csv");
        }
    };
    String[] listFolders = this.folder.list(new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return new File(file, string).isFile();
        }
    });
    String[] filenames = this.folder.list(this.jpgFilter);
    String[] foldernames = this.folder.list();
    boolean zoomBox = false;
    String str;

    public void setup() {
        this.size(this.displayWidth, this.displayHeight - 70);
        if (this.frame != null) {
            this.frame.setResizable(true);
        }
        this.registerMethod("pre", (Object)this);
        this.lblInstr = new GLabel((PApplet)this, 132.0f, 34.0f, 120.0f, 60.0f, "Use the mouse to draw a rectangle in any of the 3 windows");
        this.lblInstr.setTextAlign(GAlign.CENTER, GAlign.MIDDLE);
        this.lblInstr.setVisible(false);
        this.img = this.loadImage("GCS Logo.png");
        this.sdr = new GSlider((PApplet)this, (float)(this.width / 2 - 100), (float)(this.height - 40), 200.0f, 20.0f, 15.0f);
        this.sdr1 = new GSlider((PApplet)this, 20.0f, (float)(this.height / 2 + 100), 200.0f, 20.0f, 15.0f);
        this.sdr4 = new GSlider((PApplet)this, (float)(this.width - 37), (float)(this.height / 2), 200.0f, 20.0f, 15.0f);
        this.sdr2 = new GSlider((PApplet)this, (float)(this.width / 2 - 400), (float)(this.height - 20), 800.0f, 15.0f, 10.0f);
        this.sdr3 = new GSlider((PApplet)this, 5.0f, (float)(this.height / 2 + 200), 400.0f, 15.0f, 10.0f);
        this.sdr5 = new GSlider((PApplet)this, (float)(this.width - 20), (float)(this.height / 2 + 100), 400.0f, 20.0f, 10.0f);
        this.setSliders();
        this.rects = new ArrayList();
        this.createFileSystemGUI(90, 40, 75, 30, 6);
        this.background(250, 50.0f);
        this.pg = this.createGraphics(1280, 700);
        this.fill(255, 95.0f);
        this.newFileSettings();
        this.graph(true);
    }

    public void draw() {
    }

    public void pre() {
        if (this.currWidth != this.width || this.currHeight != this.height) {
            this.setSliders();
            this.graph(false);
            this.currWidth = this.width;
            this.currHeight = this.height;
        }
    }

    public void setBounds() {
        int n;
        this.minXval = this.getUnix(0);
        this.maxXval = this.getUnix(this.table.getRowCount() - 1);
        this.maxYval = 0;
        this.minYval = 100000;
        this.maxY2val = 0;
        this.minY2val = 150000;
        int n2 = 0;
        while (n2 < this.table.getRowCount()) {
            float f = this.mmCalc ? this.table.getFloat(n2, " Ch1") * 100.0f / this.table.getFloat(n2, " Ch4") : this.table.getFloat(n2, this.mm);
            n = (int)(f *= 1000.0f);
            if (n < 1000) {
                this.minYval = this.minYval;
            } else if (n < this.minYval) {
                this.minYval = n;
            } else if (n > this.maxYval) {
                this.maxYval = n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.table.getRowCount()) {
            float f = this.tempTCalc ? 1.0f / (0.0033540165f + 2.5163562E-4f * Graph.log((float)(this.table.getFloat(n2, this.tempT) * 10000.0f / (this.table.getFloat(n2, this.Ch4) - this.table.getFloat(n2, this.tempT)) / 10000.0f))) - 273.15f : this.table.getFloat(n2, this.tempT);
            n = (int)(f *= 1000.0f);
            if (n > 70000) {
                this.minY2val = this.minY2val;
            } else if (n < this.minY2val) {
                this.minY2val = n;
            } else if (n > this.maxY2val) {
                this.maxY2val = n;
            }
            ++n2;
        }
        this.xSpan = this.maxXval - this.minXval;
        this.ySpan = this.maxYval - this.minYval;
        this.minYval -= this.ySpan / 20;
        this.maxYval += this.ySpan / 20;
        this.minXval -= this.xSpan / 50L;
        this.maxXval += this.xSpan / 50L;
        this.minY2val -= this.y2Span / 8;
        this.maxY2val += this.y2Span / 8;
        this.vminXval = this.minXval;
        this.vmaxXval = this.maxXval;
        this.vminYval = this.minYval;
        this.vmaxYval = this.maxYval;
        this.xSpan = this.maxXval - this.minXval;
        this.ySpan = this.maxYval - this.minYval;
        this.y2Span = this.maxY2val - this.minY2val;
        this.xvSpan = this.xSpan;
        this.yvSpan = this.ySpan;
        this.y2vSpan = this.y2Span;
    }

    public long getUnix(int n) {
        int n2;
        int n3;
        String string = this.table.getString(n, this.Date);
        String[] stringArray = Graph.split((String)string, (char)'.');
        boolean bl = false;
        if (stringArray[0] == "") {
            stringArray = Graph.split((String)string, (char)'/');
            bl = true;
            Graph.print((char)'-');
        }
        string = this.table.getString(n, this.Time);
        String string2 = string.substring(1, 3);
        String[] stringArray2 = Graph.split((String)string, (char)':');
        int n4 = Integer.valueOf(stringArray[2]) - 1900;
        if (!bl) {
            n3 = Integer.valueOf(stringArray[1]) - 1;
            n2 = Integer.valueOf(stringArray[0]);
        } else {
            n3 = Integer.valueOf(stringArray[0]) - 1;
            n2 = Integer.valueOf(stringArray[1]);
        }
        int n5 = Integer.valueOf(string2) - 1;
        int n6 = Integer.valueOf(stringArray2[1]);
        int n7 = Integer.valueOf(stringArray2[2]);
        Date date = new Date(n4, n3, n2, n5, n6, n7);
        long l = date.getTime() / 1000L;
        return l;
    }

    public void graph(boolean bl) {
        this.clear();
        this.background(250, 50.0f);
        if (bl) {
            this.setBounds();
        }
        this.drawBckgnd();
        this.drawPoints();
        if (this.tempGraph) {
            this.drawPointsTemp();
        }
        this.sdr4.setVisible(this.tempGraph);
        this.sdr5.setVisible(this.tempGraph);
        this.image(this.img, 520.0f, 6.0f);
        this.text("TreeHugger CSV Viewer 3.2", 554.0f, 90.0f);
    }

    public void newFileSettings() {
        this.table = this.loadTable(this.fname, "header, csv");
        this.setColumnStringsmm();
        this.setColumnStringtempT();
        this.setColumnStringDate();
        this.setColumnStringTime();
        this.setSliders();
    }

    public void sliderShift() {
        this.vminXval += this.xSpan * (long)(this.sdr2.getValueI() - 200) / 400L;
        this.vmaxXval += this.xSpan * (long)(this.sdr2.getValueI() - 200) / 400L;
        this.vminYval += this.ySpan * (this.sdr3.getValueI() - 200) / 400;
        this.vmaxYval += this.ySpan * (this.sdr3.getValueI() - 200) / 400;
        this.vminY2val += this.ySpan * (this.sdr5.getValueI() - 200) / 400;
        this.vmaxY2val += this.ySpan * (this.sdr5.getValueI() - 200) / 400;
    }

    public void sliderZoom() {
        this.vminXval = this.minXval + this.xSpan / 400L * (long)this.sdr.getValueI();
        this.vmaxXval = this.maxXval - this.xSpan / 400L * (long)this.sdr.getValueI();
        this.vminYval = this.minYval + this.ySpan / 400 * this.sdr1.getValueI();
        this.vmaxYval = this.maxYval - this.ySpan / 400 * this.sdr1.getValueI();
        this.vminY2val = this.minY2val + this.y2Span / 400 * this.sdr4.getValueI();
        this.vmaxY2val = this.maxY2val - this.y2Span / 400 * this.sdr4.getValueI();
        this.xvSpan = this.vmaxXval - this.vminXval;
        this.yvSpan = this.vmaxYval - this.vminYval;
        this.y2vSpan = this.vmaxY2val - this.vminY2val;
    }

    public void setSliders() {
        this.sdr.setVisible(false);
        this.sdr1.setVisible(false);
        this.sdr2.setVisible(false);
        this.sdr3.setVisible(false);
        this.sdr4.setVisible(false);
        this.sdr5.setVisible(false);
        this.sdr.setLocalColorScheme(6);
        this.sdr.setOpaque(false);
        this.sdr.setValue(0.0f);
        this.sdr.setLimits(0, 199);
        this.sdr.setNumberFormat(0, 200);
        this.sdr.setRotation(0.0f, GControlMode.CENTER);
        this.sdr.moveTo((float)(this.width / 2 - 100), (float)(this.height - 40));
        this.sdr1.setLocalColorScheme(6);
        this.sdr1.setOpaque(false);
        this.sdr1.setValue(0.0f);
        this.sdr1.setLimits(0, 199);
        this.sdr1.setNumberFormat(0, 200);
        this.sdr1.setRotation(4.712389f, GControlMode.CORNER);
        this.sdr1.moveTo(20.0f, (float)(this.height / 2 + 100));
        this.sdr1.setLocalColorScheme(6);
        this.sdr2.setOpaque(false);
        this.sdr2.setLimits(0, 399);
        this.sdr2.setNumberFormat(0, 400);
        this.sdr2.setValue(200.0f);
        this.sdr2.moveTo((float)(this.width / 2 - 400), (float)(this.height - 20));
        this.sdr2.setRotation(0.0f, GControlMode.CENTER);
        this.sdr3.setLocalColorScheme(6);
        this.sdr3.setOpaque(false);
        this.sdr3.setLimits(0, 399);
        this.sdr3.setNumberFormat(0, 400);
        this.sdr3.setValue(200.0f);
        this.sdr3.setRotation(4.712389f, GControlMode.CORNER);
        this.sdr3.moveTo(5.0f, (float)(this.height / 2 + 200));
        this.sdr4.setLocalColorScheme(6);
        this.sdr4.setOpaque(false);
        this.sdr4.setLimits(0, 199);
        this.sdr4.setNumberFormat(0, 200);
        this.sdr4.setValue(0.0f);
        this.sdr4.setRotation(4.712389f, GControlMode.CORNER);
        this.sdr4.moveTo((float)(this.width - 37), (float)(this.height / 2 + 100));
        this.sdr5.setLocalColorScheme(6);
        this.sdr5.setOpaque(false);
        this.sdr5.setLimits(0, 399);
        this.sdr5.setNumberFormat(0, 400);
        this.sdr5.setValue(200.0f);
        this.sdr5.setRotation(4.712389f, GControlMode.CORNER);
        this.sdr5.moveTo((float)(this.width - 20), (float)(this.height / 2 + 200));
        this.sdr.setVisible(true);
        this.sdr1.setVisible(true);
        this.sdr2.setVisible(true);
        this.sdr3.setVisible(true);
    }

    public void drawBckgnd() {
        boolean bl = false;
        int n = 2;
        n = this.xvSpan < 7200L ? 60 : (this.xvSpan < 72000L ? 1800 : (this.xvSpan < 140000L ? 3600 : (this.xvSpan < 220000L ? 21600 : (this.xvSpan < 400000L ? 43200 : (this.xvSpan < 2420000L ? 86400 : (this.xvSpan < 12000000L ? 604800 : (this.xvSpan < 32000000L ? 2592000 : 220752000)))))));
        long l = this.vminXval;
        this.textSize(12.0f);
        this.stroke(0, 30.0f);
        while (l <= this.vmaxXval) {
            if ((l - 21600L) % (long)n == 0L) {
                long l2 = 90L + (l - this.vminXval) * (long)(this.width - 180) / this.xvSpan;
                this.fill(0);
                if (l2 > (long)(this.width - 90)) break;
                String string = n > 43400 ? new SimpleDateFormat("dd/MM/yyyy").format(new Date((l - 3600L) * 1000L)) : new SimpleDateFormat("HH:mm:ss").format(new Date((l - 3600L) * 1000L));
                if (bl) {
                    this.line(l2, 95.0f, l2, this.height - 65);
                    this.text(string, l2, this.height - 55);
                } else {
                    this.line(l2, 95.0f, l2, this.height - 55);
                    this.text(string, l2, this.height - 45);
                }
                bl = !bl;
            }
            ++l;
        }
        l = this.vmaxYval;
        int n2 = 100;
        n2 = this.yvSpan < 1000 ? 100 : (this.yvSpan < 2500 ? 250 : (this.yvSpan < 5000 ? 500 : (this.yvSpan < 10000 ? 1000 : (this.yvSpan < 25000 ? 2000 : (this.yvSpan < 50000 ? 5000 : 10000)))));
        this.textSize(14.0f);
        while (l >= (long)this.vminYval) {
            if (l % (long)n2 == 0L) {
                long l3 = 95L + ((long)this.vmaxYval - l) * (long)(this.height - 160) / (long)this.yvSpan;
                float f = (float)l / 1000.0f;
                this.stroke(0, 25.0f);
                this.line(90.0f, l3, this.width - 90, l3);
                this.fill(0);
                this.text(String.format("%.2f", Float.valueOf(f)), 43.0f, l3 + 4L);
            }
            --l;
        }
        if (this.tempGraph) {
            int n3 = 100;
            if (this.y2vSpan < 1000) {
                n2 = 100;
            } else {
                n3 = this.y2vSpan < 2500 ? 250 : (this.y2vSpan < 5000 ? 500 : (this.y2vSpan < 10000 ? 1000 : (this.y2vSpan < 50000 ? 5000 : (this.y2vSpan < 100000 ? 10000 : (this.y2vSpan < 250000 ? 25000 : 50000)))));
            }
            l = this.vmaxY2val;
            this.stroke(0, 5.0f);
            while (l >= (long)this.vminY2val) {
                if (l % (long)n3 == 0L) {
                    long l4 = 95L + ((long)this.vmaxY2val - l) * (long)(this.height - 160) / (long)this.y2vSpan;
                    this.line(90.0f, l4, this.width - 90, l4);
                    float f = (float)l / 1000.0f;
                    this.text(String.format("%.2f", Float.valueOf(f)), this.width - 81, l4 + 4L);
                }
                --l;
            }
        }
    }

    public void drawPoints() {
        int n = this.table.getRowCount();
        int n2 = 0;
        long l = 0L;
        int n3 = 0;
        this.noSmooth();
        this.fill(0);
        this.stroke(-14626976);
        this.strokeWeight(2.0f);
        while (n2 < n) {
            float f = this.mmCalc ? this.table.getFloat(n2, this.mm) * 100.0f / this.table.getFloat(n2, this.Ch4) : this.table.getFloat(n2, this.mm);
            long l2 = this.getUnix(n2);
            int n4 = (int)(f *= 1000.0f);
            int n5 = 95 + (this.vmaxYval - n4) * (this.height - 160) / this.yvSpan;
            long l3 = 90L + (l2 - this.vminXval) * (long)(this.width - 180) / this.xvSpan;
            if (n2 < 1) {
                this.point(l3, n5);
            } else if (l3 > 95L) {
                if (n5 < 200) {
                    this.stroke(-14626976, n5 * 2 - 150);
                } else if (n5 > this.height - 140) {
                    this.stroke(-14626976, (this.height - n5) * 2 - 120);
                } else {
                    this.stroke(-14626976);
                }
                this.line(l3, n5, l, n3);
            }
            l = l3;
            n3 = n5;
            ++n2;
            if (l3 > (long)(this.width - 90)) break;
        }
    }

    public void drawPointsTemp() {
        int n = this.table.getRowCount();
        int n2 = 0;
        long l = 0L;
        int n3 = 0;
        this.noSmooth();
        this.fill(0);
        this.stroke(-8048896, 25.0f);
        this.strokeWeight(2.0f);
        while (n2 < n) {
            float f = this.table.getFloat(n2, this.tempT);
            float f2 = this.table.getFloat(n2, this.Ch4);
            float f3 = this.tempTCalc ? 1.0f / (0.0033540165f + 2.5163562E-4f * Graph.log((float)(f * 10000.0f / (f2 - f) / 10000.0f))) - 273.15f : f;
            long l2 = this.getUnix(n2);
            int n4 = (int)(f3 *= 1000.0f);
            int n5 = 95 + (this.vmaxY2val - n4) * (this.height - 160) / this.y2vSpan;
            long l3 = 90L + (l2 - this.vminXval) * (long)(this.width - 180) / this.xvSpan;
            if (n2 < 1) {
                this.point(l3, n5);
            } else if (l3 > 95L) {
                if (n5 < 100) {
                    this.stroke(-8048896, n5 * 2 - 150);
                } else if (n5 > this.height - 70) {
                    this.stroke(-8048896, (this.height - n5) * 2 - 120);
                } else {
                    this.stroke(-8048896, 25.0f);
                }
                this.line(l3, n5, l, n3);
            }
            l = l3;
            n3 = n5;
            ++n2;
            if (l3 > (long)(this.width - 90)) break;
        }
    }

    public void windowMouse(GWinApplet gWinApplet, GWinData gWinData, MouseEvent mouseEvent) {
        MyWinData myWinData = (MyWinData)gWinData;
        switch (mouseEvent.getAction()) {
            case 1: {
                myWinData.sx = myWinData.ex = gWinApplet.mouseX;
                myWinData.sy = myWinData.ey = gWinApplet.mouseY;
                myWinData.done = false;
                break;
            }
            case 2: {
                myWinData.ex = gWinApplet.mouseX;
                myWinData.ey = gWinApplet.mouseY;
                myWinData.done = true;
                break;
            }
            case 4: {
                myWinData.ex = gWinApplet.mouseX;
                myWinData.ey = gWinApplet.mouseY;
            }
        }
    }

    public void handleButtonEvents(GButton gButton, GEvent gEvent) {
        if (gButton == this.btnInput) {
            this.handleFileDialog(gButton);
        } else if (gButton == this.btnRst) {
            this.sdr.setValue(0.0f);
            this.sdr1.setValue(0.0f);
            this.sdr.setValue(0.0f);
            this.sdr2.setValue(200.0f);
            this.sdr3.setValue(200.0f);
            this.sdr5.setValue(200.0f);
            this.graph(true);
        } else if (gButton == this.btntemp) {
            this.tempGraph = !this.tempGraph;
            this.graph(false);
        } else if (gButton == this.btnPNG) {
            this.saveFrame("TH_Screen-####.png");
        }
    }

    public void windowDraw(GWinApplet gWinApplet, GWinData gWinData) {
        MyWinData myWinData = (MyWinData)gWinData;
        if (myWinData.sx != myWinData.ex || myWinData.ey != myWinData.ey) {
            gWinApplet.stroke(0);
            gWinApplet.strokeWeight(2.0f);
            gWinApplet.noFill();
            if (myWinData.done) {
                gWinApplet.fill(128);
            }
            gWinApplet.rectMode(1);
            gWinApplet.rect((float)myWinData.sx, (float)myWinData.sy, (float)myWinData.ex, (float)myWinData.ey);
        }
    }

    public void createFileSystemGUI(int n, int n2, int n3, int n4, int n5) {
        this.btnInput = new GButton((PApplet)this, (float)n, (float)n2, (float)n3, (float)n4, "Input");
        this.lblFile = new GLabel((PApplet)this, (float)n, (float)(n2 - 28), (float)(n3 + 300), 28.0f);
        this.lblFile.setTextAlign(GAlign.LEFT, GAlign.MIDDLE);
        this.lblFile.setOpaque(true);
        this.lblFile.setLocalColorScheme(1);
        this.btnRst = new GButton((PApplet)this, (float)(n + 75), (float)n2, (float)n3, (float)n4, "Reset");
        this.btntemp = new GButton((PApplet)this, (float)(n + 150), (float)n2, (float)n3, (float)n4, "Temp");
        this.lblFile.setText(this.fname);
        this.btnPNG = new GButton((PApplet)this, (float)(n + 225), (float)n2, (float)n3, (float)n4, "Exp PNG");
    }

    public void handleFileDialog(GButton gButton) {
        if (gButton == this.btnInput) {
            try {
                this.fname = G4P.selectInput((String)"Input Dialog", (String)"png,gif,jpg,jpeg", (String)"Image files");
                this.fname = this.fname.replace("\\", "/");
                this.lblFile.setText(this.fname);
                this.newFileSettings();
                this.graph(true);
            }
            catch (NullPointerException nullPointerException) {
                this.fname = this.fname;
            }
        }
    }

    public void handleMessageDialog() {
        int n;
        switch (this.md_mtype) {
            default: {
                n = -1;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
            }
        }
        String string = this.txfSMMessage.getText();
        String string2 = this.txfMdTitle.getText();
        G4P.showMessage((Object)((Object)this), (String)string, (String)string2, (int)n);
    }

    public void handleSliderEvents(GValueControl gValueControl, GEvent gEvent) {
        if (gValueControl == this.sdr || gValueControl == this.sdr1 || gValueControl == this.sdr2 || gValueControl == this.sdr3 || gValueControl == this.sdr4 || gValueControl == this.sdr5) {
            this.sliderZoom();
            this.sliderShift();
            this.graph(false);
        }
    }

    public void mousePressed() {
        if (this.mouseX < this.width - 90 && this.mouseX > 90 && this.mouseY < this.height - 65 && this.mouseY > 90) {
            this.mx = this.mouseX;
            this.my = this.mouseY;
            this.zoomBox = true;
            this.loadPixels();
        }
    }

    public void mouseDragged() {
        if (this.mouseX < this.width - 90 && this.mouseX > 90 && this.mouseY < this.height - 65 && this.mouseY > 90 && this.zoomBox) {
            this.pg.beginDraw();
            this.pg.background(255, 0.0f);
            this.pg.stroke(0, 15.0f);
            this.pg.rectMode(1);
            this.pg.fill(-14626976, 20.0f);
            this.pg.rect((float)this.mx, (float)this.my, (float)this.mouseX, (float)this.mouseY);
            this.pg.endDraw();
            this.updatePixels();
            this.image((PImage)this.pg, 0.0f, 0.0f);
        }
    }

    public void mouseReleased() {
        if (this.mouseX < this.width - 90 && this.mouseX > 90 && this.mouseY < this.height - 65 && this.mouseY > 90 && this.zoomBox) {
            if (this.mouseX > this.mx) {
                this.vmaxXval = (long)(this.mouseX - 90) * this.xvSpan / (long)(this.width - 180) + this.vminXval;
                this.vminXval = (long)(this.mx - 90) * this.xvSpan / (long)(this.width - 180) + this.vminXval;
            } else {
                this.vmaxXval = (long)(this.mx - 90) * this.xvSpan / (long)(this.width - 180) + this.vminXval;
                this.vminXval = (long)(this.mouseX - 90) * this.xvSpan / (long)(this.width - 180) + this.vminXval;
            }
            if (this.mouseY < this.my) {
                this.vmaxYval = (this.height - this.mouseY - 65) * this.yvSpan / (this.height - 160) + this.vminYval;
                this.vminYval = (this.height - this.my - 65) * this.yvSpan / (this.height - 160) + this.vminYval;
            } else {
                this.vmaxYval = (this.height - this.my - 65) * this.yvSpan / (this.height - 160) + this.vminYval;
                this.vminYval = (this.height - this.mouseY - 65) * this.yvSpan / (this.height - 160) + this.vminYval;
            }
            this.xvSpan = this.vmaxXval - this.vminXval;
            this.yvSpan = this.vmaxYval - this.vminYval;
            this.sdr2.setValue((float)((this.xvSpan / 2L + this.vminXval - this.minXval) * 400L / this.xSpan));
            this.sdr3.setValue((float)((this.yvSpan / 2 + this.vminYval - this.minYval) * 400 / this.ySpan));
            this.sdr.setValue((float)(200L - this.xvSpan * 200L / this.xSpan));
            this.sdr1.setValue((float)(200 - this.yvSpan * 200 / this.ySpan));
            this.zoomBox = false;
        }
    }

    public void setColumnStringsmm() {
        try {
            this.F = this.table.getFloat(1, " mm");
            this.mm = "";
            this.mm = " mm";
            this.mmCalc = false;
        }
        catch (Exception exception) {
            try {
                this.F = this.table.getFloat(1, "mm");
                this.mm = "";
                this.mm = "mm";
                this.mmCalc = false;
            }
            catch (Exception exception2) {
                try {
                    this.F = this.table.getFloat(1, " Ch1");
                    this.mm = "";
                    this.mm = " Ch1";
                    this.mmCalc = true;
                }
                catch (Exception exception3) {
                    try {
                        this.F = this.table.getFloat(1, " ch1");
                        this.mm = "";
                        this.mm = " ch1";
                        this.mmCalc = true;
                    }
                    catch (Exception exception4) {
                        try {
                            this.F = this.table.getFloat(1, "ch1");
                            this.mm = "";
                            this.mm = "ch1";
                            this.mmCalc = true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.F = this.table.getFloat(1, "Ch1");
                            this.mm = "";
                            this.mm = "Ch1";
                            this.mmCalc = true;
                        }
                    }
                }
            }
        }
    }

    public void setColumnStringtempT() {
        try {
            this.F = this.table.getFloat(1, " Temp");
            this.tempT = "";
            this.tempT = " Temp";
            this.tempTCalc = false;
        }
        catch (Exception exception) {
            try {
                this.F = this.table.getFloat(1, "Temp");
                this.tempT = "";
                this.tempT = "Temp";
                this.tempTCalc = false;
            }
            catch (Exception exception2) {
                try {
                    this.F = this.table.getFloat(1, " Ch2");
                    this.tempT = "";
                    this.tempT = " Ch2";
                    this.Ch4 = " Ch4";
                    this.tempTCalc = true;
                }
                catch (Exception exception3) {
                    try {
                        this.F = this.table.getFloat(1, " ch2");
                        this.tempT = "";
                        this.tempT = " ch2";
                        this.Ch4 = " ch4";
                        this.tempTCalc = true;
                    }
                    catch (Exception exception4) {
                        try {
                            this.F = this.table.getFloat(1, "ch2");
                            this.tempT = "";
                            this.tempT = "ch2";
                            this.Ch4 = "ch4";
                            this.tempTCalc = true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.F = this.table.getFloat(1, "Ch2");
                            this.tempT = "";
                            this.tempT = "Ch2";
                            this.Ch4 = "Ch4";
                            this.tempTCalc = true;
                        }
                    }
                }
            }
        }
    }

    public void setColumnStringTime() {
        try {
            this.str = this.table.getString(1, " Time");
            this.Time = "";
            this.Time = " Time";
        }
        catch (Exception exception) {
            try {
                this.F = this.table.getFloat(1, "Time");
                this.Time = "";
                this.Time = "Time";
            }
            catch (Exception exception2) {
                try {
                    this.F = this.table.getFloat(1, " time");
                    this.Time = "";
                    this.Time = " time";
                }
                catch (Exception exception3) {
                    this.F = this.table.getFloat(1, "time");
                    this.Time = "";
                    this.Time = "time";
                }
            }
        }
    }

    public void setColumnStringDate() {
        try {
            this.str = this.table.getString(1, " Date");
            this.Date = "";
            this.Date = " Date";
        }
        catch (Exception exception) {
            try {
                this.F = this.table.getFloat(1, "Date");
                this.Date = "";
                this.Date = "Date";
            }
            catch (Exception exception2) {
                try {
                    this.F = this.table.getFloat(1, " date");
                    this.Date = "";
                    this.Date = " date";
                }
                catch (Exception exception3) {
                    this.F = this.table.getFloat(1, "date");
                    this.Date = "";
                    this.Date = "date";
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"Graph"};
        if (stringArray != null) {
            PApplet.main((String[])Graph.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class MyWinData
    extends GWinData {
        int sx;
        int sy;
        int ex;
        int ey;
        boolean done;

        MyWinData() {
        }
    }
}

