/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GEvent;
import g4p_controls.HotSpot;
import g4p_controls.ImageManager;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GImageToggleButton
extends GAbstractControl {
    private static PImage toggle = null;
    private static final String TOGGLE = "toggle.png";
    protected int nbrStates = 2;
    protected int stateValue = 0;
    protected PImage[] offImage;
    protected PImage[] overImage;
    protected int status;
    protected boolean reportAllButtonEvents = false;

    public GImageToggleButton(PApplet pApplet, float f, float f2) {
        this(pApplet, f, f2, null, null, 1, 1);
    }

    public GImageToggleButton(PApplet pApplet, float f, float f2, String string, int n) {
        this(pApplet, f, f2, string, null, n, 1);
    }

    public GImageToggleButton(PApplet pApplet, float f, float f2, String string, int n, int n2) {
        this(pApplet, f, f2, string, null, n, n2);
    }

    public GImageToggleButton(PApplet pApplet, float f, float f2, String string, String string2, int n) {
        this(pApplet, f, f2, string, string2, n, 1);
    }

    public GImageToggleButton(PApplet pApplet, float f, float f2, String string, String string2, int n, int n2) {
        super(pApplet, f, f2);
        PImage pImage = null;
        if (n < 1 || n2 < 1 || string == null || null == (pImage = ImageManager.loadImage(this.winApp, string))) {
            this.nbrStates = 2;
            if (toggle == null) {
                toggle = ImageManager.loadImage(this.winApp, TOGGLE);
            }
            this.offImage = ImageManager.makeTiles1D(this.winApp, toggle, 2, 1);
        } else {
            this.nbrStates = n * n2;
            this.offImage = ImageManager.makeTiles1D(this.winApp, pImage, n, n2);
            if (string2 != null && null != (pImage = ImageManager.loadImage(this.winApp, string2))) {
                this.overImage = ImageManager.makeTiles1D(this.winApp, pImage, n, n2);
            }
        }
        this.resize(this.offImage[0].width, this.offImage[0].height);
        this.hotspots = new HotSpot[]{new HotSpot.HSalpha(1, 0.0f, 0.0f, this.offImage[this.stateValue], 0)};
        this.z = 24;
        this.createEventHandler(G4P.sketchApplet, "handleToggleButtonEvents", new Class[]{GImageToggleButton.class, GEvent.class}, new String[]{"button", "event"});
        this.registeredMethods = 3;
        this.cursorOver = 12;
        G4P.addControl(this);
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        if (this.status == 1 && this.overImage != null) {
            this.winApp.image(this.overImage[this.stateValue], 0.0f, 0.0f);
        } else {
            this.winApp.image(this.offImage[this.stateValue], 0.0f, 0.0f);
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot < 0 || this.z <= GImageToggleButton.focusObjectZ()) break;
                this.dragging = false;
                this.status = 2;
                this.takeFocus();
                if (!this.reportAllButtonEvents) break;
                this.fireEvent(new Object[]{this, GEvent.PRESSED});
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                this.status = 0;
                this.loseFocus(null);
                this.dragging = false;
                this.nextState();
                this.fireEvent(new Object[]{this, GEvent.CLICKED});
                break;
            }
            case 2: {
                if (focusIsWith != this || !this.dragging) break;
                if (this.currSpot >= 0) {
                    this.nextState();
                    this.fireEvent(new Object[]{this, GEvent.CLICKED});
                } else if (this.reportAllButtonEvents) {
                    this.fireEvent(new Object[]{this, GEvent.RELEASED});
                }
                this.dragging = false;
                this.loseFocus(null);
                this.status = 0;
                break;
            }
            case 5: {
                if (this.currSpot >= 0) {
                    this.status = 1;
                    break;
                }
                this.status = 0;
                break;
            }
            case 4: {
                this.dragging = focusIsWith == this;
            }
        }
    }

    private void nextState() {
        ++this.stateValue;
        this.stateValue %= this.nbrStates;
        this.hotspots[0].adjust(0, 0, this.offImage[this.stateValue]);
    }

    @Deprecated
    public int stateValue() {
        return this.stateValue;
    }

    public int getState() {
        return this.stateValue;
    }

    @Deprecated
    public void stateValue(int n) {
        if (n >= 0 && n < this.nbrStates && n != this.stateValue) {
            this.stateValue = n;
            this.hotspots[0].adjust(0, 0, this.offImage[this.stateValue]);
            this.bufferInvalid = true;
        }
    }

    public void setState(int n) {
        if (n >= 0 && n < this.nbrStates && n != this.stateValue) {
            this.stateValue = n;
            this.hotspots[0].adjust(0, 0, this.offImage[this.stateValue]);
            this.bufferInvalid = true;
        }
    }

    public void fireAllEvents(boolean bl) {
        this.reportAllButtonEvents = bl;
    }
}

