/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.GConstants;
import g4p_controls.GMessenger;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import processing.core.PApplet;
import processing.core.PImage;

public class GCScheme
implements GConstants {
    private static int[][] palettes = null;
    private static Color[][] jpalettes = null;

    public static int[] getColor(int n) {
        n = Math.abs(n) % 16;
        return palettes[n];
    }

    public static Color[] getJavaColor(int n) {
        n = Math.abs(n) % 16;
        return jpalettes[n];
    }

    public static void makeColorSchemes(PApplet pApplet) {
        if (palettes != null) {
            return;
        }
        PImage pImage = null;
        InputStream inputStream = pApplet.createInput("user_gui_palette.png");
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            pImage = pApplet.loadImage("user_gui_palette.png");
            GMessenger.message(65794, null);
        } else {
            pImage = pApplet.loadImage("default_gui_palette.png");
            if (pImage == null) {
                pImage = new PImage(new ImageIcon(new GCScheme().getClass().getResource("/data/default_gui_palette.png")).getImage());
            }
        }
        palettes = new int[16][16];
        jpalettes = new Color[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int n;
                GCScheme.palettes[i][j] = n = pImage.get(j * 16 + 8, i * 16 + 8);
                GCScheme.jpalettes[i][j] = new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
            }
        }
    }

    public static void makeColorSchemes() {
        if (palettes != null) {
            return;
        }
        PImage pImage = new PImage(new ImageIcon(new GCScheme().getClass().getResource("/data/default_gui_palette.png")).getImage());
        palettes = new int[16][16];
        jpalettes = new Color[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int n;
                GCScheme.palettes[i][j] = n = pImage.get(j * 16 + 8, i * 16 + 8);
                GCScheme.jpalettes[i][j] = new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
            }
        }
    }
}

